/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;

public class ScriptType {
    public static final String CAPABILITY_APPEND = "append";
    private String name;
    private String i18nKey;
    private ImageIcon icon;
    private boolean isEnableable;
    private Set<String> capabilitiesSet = new HashSet<String>();

    public ScriptType(String name, String i18nKey, ImageIcon icon, boolean isEnableable) {
        this(name, i18nKey, icon, isEnableable, null);
    }

    public ScriptType(String name, String i18nKey, ImageIcon icon, boolean isEnableable, String[] capabilities) {
        this.name = name;
        this.i18nKey = i18nKey;
        this.icon = icon;
        this.isEnableable = isEnableable;
        if (capabilities != null) {
            for (String capability : capabilities) {
                this.capabilitiesSet.add(capability);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getI18nKey() {
        return this.i18nKey;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public boolean isEnableable() {
        return this.isEnableable;
    }

    public void addCapability(String capability) {
        this.capabilitiesSet.add(capability);
    }

    public boolean hasCapability(String capability) {
        return this.capabilitiesSet.contains(capability);
    }
}

