/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.OptionsScriptTableModel;
import org.zaproxy.zap.extension.script.ScriptParam;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;

public class OptionsScriptPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private ExtensionScript extension;
    private AntiCsrfMultipleOptionsPanel tokensOptionsPanel;
    private OptionsScriptTableModel scriptDirModel = null;

    public OptionsScriptPanel(ExtensionScript extension) {
        this.extension = extension;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("options.script.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 21;
        gbc.fill = 1;
        this.add((Component)new JLabel(Constant.messages.getString("options.script.label.dirs")), gbc);
        this.tokensOptionsPanel = new AntiCsrfMultipleOptionsPanel(this.extension, this.getScriptDirModel());
        gbc.weighty = 1.0;
        this.add((Component)this.tokensOptionsPanel, gbc);
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam optionsParam = (OptionsParam)obj;
        ScriptParam param = optionsParam.getParamSet(ScriptParam.class);
        this.getScriptDirModel().setTokens(param.getScriptDirs());
        this.tokensOptionsPanel.setRemoveWithoutConfirmation(!param.isConfirmRemoveDir());
    }

    @Override
    public void validateParam(Object obj) throws Exception {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam optionsParam = (OptionsParam)obj;
        ScriptParam param = optionsParam.getParamSet(ScriptParam.class);
        List<File> dirs = this.getScriptDirModel().getElements();
        for (File dir : param.getScriptDirs()) {
            if (dirs.contains(dir)) continue;
            this.extension.removeScriptsFromDir(dir);
        }
        for (File dir : dirs) {
            if (param.getScriptDirs().contains(dir)) continue;
            this.extension.addScriptsFromDir(dir);
        }
        param.setScriptDirs(dirs);
        param.setConfirmRemoveDir(!this.tokensOptionsPanel.isRemoveWithoutConfirmation());
    }

    private OptionsScriptTableModel getScriptDirModel() {
        if (this.scriptDirModel == null) {
            this.scriptDirModel = new OptionsScriptTableModel();
        }
        return this.scriptDirModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.script";
    }

    private static class AntiCsrfMultipleOptionsPanel
    extends AbstractMultipleOptionsBaseTablePanel<File> {
        private static final long serialVersionUID = -115340627058929308L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("options.script.dialog.dirs.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("options.script.dialog.dirs.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.script.dialog.dirs.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("options.script.dialog.dirs.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("options.script.dialog.dirs.remove.checkbox.label");
        private static ExtensionScript extension;

        public AntiCsrfMultipleOptionsPanel(ExtensionScript ext, OptionsScriptTableModel model) {
            super(model);
            extension = ext;
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
        }

        @Override
        public File showAddDialogue() {
            return this.showDirSelectDialog(null);
        }

        @Override
        public File showModifyDialogue(File dir) {
            return this.showDirSelectDialog(dir);
        }

        private File showDirSelectDialog(File dir) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            if (fc.showOpenDialog(this) == 0) {
                File file = fc.getSelectedFile();
                if (extension.getScriptCount(file) == 0) {
                    if (View.getSingleton().showConfirmDialog(this, Constant.messages.getString("options.script.dialog.dirs.noscripts.warning")) == 0) {
                        return file;
                    }
                } else {
                    return file;
                }
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(File f) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

