/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.view.StatusUI;

public class PolicyPassiveScanTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.policy.table.testname"), Constant.messages.getString("ascan.policy.table.threshold"), Constant.messages.getString("ascan.policy.table.quality")};
    private static final int QUALITY_COLUMN_IDX = 2;
    private List<ScannerWrapper> listScanners = new ArrayList<ScannerWrapper>();
    private Map<String, String> i18nToStr = null;

    public void addScanner(PluginPassiveScanner scanner) {
        this.listScanners.add(new ScannerWrapper(scanner, View.getSingleton().getStatusUI(scanner.getStatus())));
        this.fireTableDataChanged();
    }

    public void persistChanges() {
        for (ScannerWrapper ss : this.listScanners) {
            ss.persistChanges();
        }
    }

    public void reset() {
        for (ScannerWrapper ss : this.listScanners) {
            ss.reset();
        }
    }

    public void applyThreshold(Plugin.AlertThreshold threshold, String quality) {
        for (ScannerWrapper ss : this.listScanners) {
            if (!quality.equals(ss.getQuality().toString())) continue;
            ss.setThreshold(threshold);
        }
    }

    public void applyThresholdToAll(Plugin.AlertThreshold threshold) {
        for (ScannerWrapper ss : this.listScanners) {
            ss.setThreshold(threshold);
        }
    }

    public void removeScanner(PluginPassiveScanner scanner) {
        for (int i = 0; i < this.listScanners.size(); ++i) {
            if (!scanner.equals(this.listScanners.get(i).getScanner())) continue;
            this.listScanners.remove(i);
            this.fireTableRowsDeleted(i, i);
            break;
        }
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 2) {
            return StatusUI.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ScannerWrapper test = this.listScanners.get(row);
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                Plugin.AlertThreshold af = Plugin.AlertThreshold.valueOf(this.i18nToStr((String)value));
                test.setThreshold(af);
                this.fireTableCellUpdated(row, col);
            }
        }
    }

    private String strToI18n(String str) {
        return Constant.messages.getString("ascan.policy.level." + str.toLowerCase());
    }

    private String i18nToStr(String str) {
        if (this.i18nToStr == null) {
            this.i18nToStr = new HashMap<String, String>();
            for (Plugin.AlertThreshold at : Plugin.AlertThreshold.values()) {
                this.i18nToStr.put(this.strToI18n(at.name()), at.name());
            }
        }
        return this.i18nToStr.get(str);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.listScanners == null) {
            return 0;
        }
        return this.listScanners.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        ScannerWrapper test = this.listScanners.get(row);
        Object result = null;
        switch (col) {
            case 0: {
                result = test.getName();
                break;
            }
            case 1: {
                result = this.strToI18n(test.getThreshold().name());
                break;
            }
            case 2: {
                result = test.getQuality();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private static class ScannerWrapper {
        private final PluginPassiveScanner scanner;
        private final StatusUI quality;
        private Plugin.AlertThreshold threshold;

        public ScannerWrapper(PluginPassiveScanner scanner, StatusUI quality) {
            this.scanner = scanner;
            this.quality = quality;
            this.reset();
        }

        public PluginPassiveScanner getScanner() {
            return this.scanner;
        }

        public void reset() {
            this.threshold = this.scanner.getLevel();
        }

        public void persistChanges() {
            this.scanner.setLevel(this.threshold);
            this.scanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)this.threshold));
            this.scanner.save();
        }

        public String getName() {
            return this.scanner.getName();
        }

        public Plugin.AlertThreshold getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Plugin.AlertThreshold threshold) {
            this.threshold = threshold;
        }

        public StatusUI getQuality() {
            return this.quality;
        }
    }
}

