/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class PassiveScanAPI
extends ApiImplementor {
    private static final Logger logger = Logger.getLogger(PassiveScanAPI.class);
    private static final String PREFIX = "pscan";
    private static final String VIEW_RECORDS_TO_SCAN = "recordsToScan";
    private static final String VIEW_SCANNERS = "scanners";
    private static final String ACTION_SET_ENABLED = "setEnabled";
    private static final String ACTION_ENABLE_ALL_SCANNERS = "enableAllScanners";
    private static final String ACTION_DISABLE_ALL_SCANNERS = "disableAllScanners";
    private static final String ACTION_ENABLE_SCANNERS = "enableScanners";
    private static final String ACTION_DISABLE_SCANNERS = "disableScanners";
    private static final String ACTION_SET_SCANNER_ALERT_THRESHOLD = "setScannerAlertThreshold";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_ID = "id";
    private static final String PARAM_ALERT_THRESHOLD = "alertThreshold";
    private ExtensionPassiveScan extension;

    public PassiveScanAPI(ExtensionPassiveScan extension) {
        this.extension = extension;
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED, new String[]{PARAM_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_SCANNERS));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_SCANNERS));
        this.addApiAction(new ApiAction(ACTION_ENABLE_SCANNERS, new String[]{PARAM_IDS}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_SCANNERS, new String[]{PARAM_IDS}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}));
        this.addApiView(new ApiView(VIEW_RECORDS_TO_SCAN));
        this.addApiView(new ApiView(VIEW_SCANNERS));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        switch (name) {
            case "setEnabled": {
                boolean enabled = this.getParam(params, PARAM_ENABLED, false);
                this.extension.setPassiveScanEnabled(enabled);
                break;
            }
            case "enableAllScanners": {
                this.extension.setAllPluginPassiveScannersEnabled(true);
                break;
            }
            case "disableAllScanners": {
                this.extension.setAllPluginPassiveScannersEnabled(false);
                break;
            }
            case "enableScanners": {
                this.setPluginPassiveScannersEnabled(params, true);
                break;
            }
            case "disableScanners": {
                this.setPluginPassiveScannersEnabled(params, false);
                break;
            }
            case "setScannerAlertThreshold": {
                int pluginId;
                String paramId = params.getString(PARAM_ID);
                try {
                    pluginId = Integer.valueOf(paramId.trim());
                }
                catch (NumberFormatException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ID);
                }
                if (!this.extension.hasPluginPassiveScanner(pluginId)) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ID);
                }
                Plugin.AlertThreshold alertThreshold = PassiveScanAPI.getAlertThresholdFromParamAlertThreshold(params);
                this.extension.setPluginPassiveScannerAlertThreshold(pluginId, alertThreshold);
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
        }
        return ApiResponseElement.OK;
    }

    private void setPluginPassiveScannersEnabled(JSONObject params, boolean enabled) {
        String[] ids = this.getParam(params, PARAM_IDS, "").split(",");
        if (ids.length > 0) {
            for (String id : ids) {
                try {
                    int pluginId = Integer.valueOf(id.trim());
                    if (pluginId <= 0) continue;
                    this.extension.setPluginPassiveScannerEnabled(pluginId, enabled);
                }
                catch (NumberFormatException e) {
                    logger.error((Object)("Failed to parse scanner ID: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private static Plugin.AlertThreshold getAlertThresholdFromParamAlertThreshold(JSONObject params) throws ApiException {
        String paramAlertThreshold = params.getString(PARAM_ALERT_THRESHOLD).trim().toUpperCase();
        try {
            return Plugin.AlertThreshold.valueOf(paramAlertThreshold);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ALERT_THRESHOLD);
        }
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        switch (name) {
            case "recordsToScan": {
                result = new ApiResponseElement(name, String.valueOf(this.extension.getRecordsToScan()));
                break;
            }
            case "scanners": {
                List<PluginPassiveScanner> scanners = this.extension.getPluginPassiveScanners();
                ApiResponseList resultList = new ApiResponseList(name);
                for (PluginPassiveScanner scanner : scanners) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(PARAM_ID, String.valueOf(scanner.getPluginId()));
                    map.put("name", scanner.getName());
                    map.put(PARAM_ENABLED, String.valueOf(scanner.isEnabled()));
                    map.put(PARAM_ALERT_THRESHOLD, scanner.getLevel(true).name());
                    map.put("quality", scanner.getStatus().toString());
                    resultList.addItem(new ApiResponseSet("scanner", map));
                }
                result = resultList;
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return result;
    }
}

