/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.log4j;

import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.ScanStatus;

public class ZapOutputWriter
extends WriterAppender {
    private static final char NEWLINE = '\n';
    private ScanStatus scanStatus = null;

    public ZapOutputWriter() {
        System.out.println("ZapOutputWriter constructor");
    }

    public ZapOutputWriter(ScanStatus scanStatus) {
        this.scanStatus = scanStatus;
    }

    public void append(final LoggingEvent event) {
        if (!View.isInitialised()) {
            return;
        }
        if (event.getLevel().equals((Object)Level.ERROR)) {
            String[] tsr;
            String renderedmessage;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZapOutputWriter.this.append(event);
                    }
                });
                return;
            }
            if (this.scanStatus != null) {
                this.scanStatus.incScanCount();
            }
            if ((renderedmessage = event.getRenderedMessage()) != null) {
                View.getSingleton().getOutputPanel().append(renderedmessage + '\n');
            }
            if ((tsr = event.getThrowableStrRep()) != null) {
                StringBuilder eventThrowableStrRep = new StringBuilder(tsr.length * 75);
                for (String str : tsr) {
                    eventThrowableStrRep.append(str).append('\n');
                }
                View.getSingleton().getOutputPanel().append(eventThrowableStrRep.toString());
            }
        }
    }
}

