/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.split.response;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseBodyStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseBodyPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    public HttpResponseBodyPanelSyntaxHighlightTextView(ResponseBodyStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseBodyPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseBodyPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = -8952571125337022950L;
        private static final String CSS = Constant.messages.getString("http.panel.view.syntaxtext.syntax.css");
        private static final String HTML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.html");
        private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
        private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
        private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");
        private static ResponseBodyTokenMakerFactory tokenMakerFactory = null;

        public HttpResponseBodyPanelSyntaxHighlightTextArea() {
            this.addSyntaxStyle(CSS, "text/css");
            this.addSyntaxStyle(HTML, "text/html");
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                matches.add(new SearchMatch(SearchMatch.Location.RESPONSE_BODY, m.start(), m.end()));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.RESPONSE_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            int len = this.getText().length();
            if (sm.getStart() > len || sm.getEnd() > len) {
                return;
            }
            this.highlight(sm.getStart(), sm.getEnd());
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String contentType;
            String syntax = null;
            if (httpMessage != null && (contentType = httpMessage.getResponseHeader().getHeader("Content-Type")) != null && !contentType.isEmpty()) {
                int pos = (contentType = contentType.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (pos != -1) {
                    contentType = contentType.substring(0, pos).trim();
                }
                syntax = contentType.contains("javascript") ? "text/javascript" : (contentType.contains("json") ? "text/json" : (contentType.contains("xhtml") ? "text/html" : (contentType.contains("xml") ? "text/xml" : contentType)));
            }
            return syntax;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseBodyTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseBodyTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public ResponseBodyTokenMakerFactory() {
                String pkg = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/css", pkg + "CSSTokenMaker");
                this.putMapping("text/html", pkg + "HTMLTokenMaker");
                this.putMapping("text/javascript", pkg + "JavaScriptTokenMaker");
                this.putMapping("text/json", pkg + "JsonTokenMaker");
                this.putMapping("text/xml", pkg + "XMLTokenMaker");
            }
        }
    }
}

