/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.split.request;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestHeaderStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.CaretVisibilityEnforcerOnFocusGain;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.model.DefaultTextHttpMessageLocation;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;
import org.zaproxy.zap.view.messagecontainer.http.SelectableContentHttpMessageContainer;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListenerAdapter;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightsManager;

public class HttpRequestHeaderPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView
implements SelectableContentHttpMessageContainer {
    public static final String NAME = "HttpRequestHeaderSyntaxTextView";
    private MessageLocationProducerFocusListenerAdapter focusListenerAdapter;

    public HttpRequestHeaderPanelSyntaxHighlightTextView(RequestHeaderStringHttpPanelViewModel model) {
        super(model);
        this.getHttpPanelTextArea().setComponentPopupMenu(new HttpPanelSyntaxHighlightTextView.CustomPopupMenu(){
            private static final long serialVersionUID = -426000345249750052L;

            @Override
            public void show(Component invoker, int x, int y) {
                if (!HttpRequestHeaderPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().isFocusOwner()) {
                    HttpRequestHeaderPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().requestFocusInWindow();
                }
                View.getSingleton().getPopupMenu().show(HttpRequestHeaderPanelSyntaxHighlightTextView.this, x, y);
            }
        });
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpRequestHeaderPanelSyntaxHighlightTextArea();
    }

    @Override
    protected HttpRequestHeaderPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return (HttpRequestHeaderPanelSyntaxHighlightTextArea)super.getHttpPanelTextArea();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public Class<? extends MessageLocation> getMessageLocationClass() {
        return TextHttpMessageLocation.class;
    }

    @Override
    public MessageLocation getSelection() {
        return this.getHttpPanelTextArea().getSelection();
    }

    @Override
    public MessageLocationHighlightsManager create() {
        return this.getHttpPanelTextArea().create();
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (!this.supports(location)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, new TextMessageLocationHighlight(Color.LIGHT_GRAY));
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (!this.supports(location) || !(highlight instanceof TextMessageLocationHighlight)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        TextMessageLocationHighlight textHighlight = (TextMessageLocationHighlight)highlight;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, textHighlight);
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (!(highlightReference instanceof TextMessageLocationHighlight)) {
            return;
        }
        this.getHttpPanelTextArea().removeHighlight(((TextMessageLocationHighlight)highlightReference).getHighlightReference());
    }

    @Override
    public boolean supports(MessageLocation location) {
        if (!(location instanceof TextHttpMessageLocation)) {
            return false;
        }
        return ((TextHttpMessageLocation)location).getLocation() == HttpMessageLocation.Location.REQUEST_HEADER;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        return TextHttpMessageLocation.class.isAssignableFrom(classLocation);
    }

    @Override
    public void addFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().removeFocusListener(focusListener);
        if (!this.getFocusListenerAdapter().hasFocusListeners()) {
            this.getHttpPanelTextArea().removeFocusListener(this.focusListenerAdapter);
            this.focusListenerAdapter = null;
        }
    }

    @Override
    public HttpMessage getMessage() {
        return this.getHttpPanelTextArea().getMessage();
    }

    @Override
    public Component getComponent() {
        return this.getHttpPanelTextArea();
    }

    @Override
    public boolean isEmpty() {
        return this.getHttpPanelTextArea().getMessage() == null;
    }

    private MessageLocationProducerFocusListenerAdapter getFocusListenerAdapter() {
        if (this.focusListenerAdapter == null) {
            this.focusListenerAdapter = new MessageLocationProducerFocusListenerAdapter(this);
            this.getHttpPanelTextArea().addFocusListener(this.focusListenerAdapter);
        }
        return this.focusListenerAdapter;
    }

    private static class HttpRequestHeaderPanelSyntaxHighlightTextArea
    extends HttpPanelSyntaxHighlightTextArea {
        private static final long serialVersionUID = -4532294585338584747L;
        private static final Logger log = Logger.getLogger(HttpRequestHeaderPanelSyntaxHighlightTextArea.class);
        private static RequestHeaderTokenMakerFactory tokenMakerFactory = null;
        private CaretVisibilityEnforcerOnFocusGain caretVisiblityEnforcer = new CaretVisibilityEnforcerOnFocusGain((JTextComponent)((Object)this));

        public String getName() {
            return HttpRequestHeaderPanelSyntaxHighlightTextView.NAME;
        }

        @Override
        public HttpMessage getMessage() {
            return (HttpMessage)super.getMessage();
        }

        @Override
        public void setMessage(Message aMessage) {
            super.setMessage(aMessage);
            this.caretVisiblityEnforcer.setEnforceVisibilityOnFocusGain(aMessage != null);
        }

        protected MessageLocation getSelection() {
            int start = this.getSelectionStart();
            try {
                start += this.getLineOfOffset(start);
            }
            catch (BadLocationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
            }
            int end = this.getSelectionEnd();
            try {
                end += this.getLineOfOffset(end);
            }
            catch (BadLocationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
            }
            if (start == end) {
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, start);
            }
            return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, start, end, this.getMessage().getRequestHeader().toString().substring(start, end));
        }

        protected MessageLocationHighlightsManager create() {
            return new TextMessageLocationHighlightsManager();
        }

        protected MessageLocationHighlight highlightImpl(TextHttpMessageLocation textLocation, TextMessageLocationHighlight textHighlight) {
            int finalEndPos;
            if (this.getMessage() == null) {
                return null;
            }
            int excessChars = 0;
            String header = this.getMessage().getRequestHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && pos < textLocation.getStart()) {
                pos += 2;
                ++excessChars;
            }
            int len = this.getText().length();
            int finalStartPos = textLocation.getStart() - excessChars;
            if (finalStartPos > len) {
                return null;
            }
            if (pos != -1) {
                while ((pos = header.indexOf("\r\n", pos)) != -1 && pos < textLocation.getEnd()) {
                    pos += 2;
                    ++excessChars;
                }
            }
            if ((finalEndPos = textLocation.getEnd() - excessChars) > len) {
                return null;
            }
            textHighlight.setHighlightReference(this.highlight(finalStartPos, finalEndPos, textHighlight));
            return textHighlight;
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int start = m.start();
                try {
                    start += this.getLineOfOffset(start);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                int end = m.end();
                try {
                    end += this.getLineOfOffset(end);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return;
                }
                matches.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, start, end));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation())) {
                return;
            }
            int t = 0;
            String header = sm.getMessage().getRequestHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && pos < sm.getStart()) {
                pos += 2;
                ++t;
            }
            int len = this.getText().length();
            if (sm.getStart() - t > len || sm.getEnd() - t > len) {
                return;
            }
            this.highlight(sm.getStart() - t, sm.getEnd() - t);
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new RequestHeaderTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class RequestHeaderTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
        }
    }
}

