/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.all.response;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.AutoDetectSyntaxHttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseAllPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView {
    private static final String CSS = Constant.messages.getString("http.panel.view.syntaxtext.syntax.css");
    private static final String HTML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.html");
    private static final String JAVASCRIPT = Constant.messages.getString("http.panel.view.syntaxtext.syntax.javascript");
    private static final String JSON = Constant.messages.getString("http.panel.view.syntaxtext.syntax.json");
    private static final String XML = Constant.messages.getString("http.panel.view.syntaxtext.syntax.xml");

    public HttpResponseAllPanelSyntaxHighlightTextView(ResponseStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpResponseAllPanelSyntaxHighlightTextArea();
    }

    private static class HttpResponseAllPanelSyntaxHighlightTextArea
    extends AutoDetectSyntaxHttpPanelTextArea {
        private static final long serialVersionUID = 3665478428546560762L;
        private static final Logger log = Logger.getLogger(HttpResponseAllPanelSyntaxHighlightTextArea.class);
        private static ResponseAllTokenMakerFactory tokenMakerFactory = null;

        public HttpResponseAllPanelSyntaxHighlightTextArea() {
            this.addSyntaxStyle(CSS, "text/css");
            this.addSyntaxStyle(HTML, "text/html");
            this.addSyntaxStyle(JAVASCRIPT, "text/javascript");
            this.addSyntaxStyle(JSON, "text/json");
            this.addSyntaxStyle(XML, "text/xml");
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            HttpMessage httpMessage = (HttpMessage)this.getMessage();
            int tHeader = 0;
            String header = httpMessage.getResponseHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1) {
                pos += 2;
                ++tHeader;
            }
            int headerLen = header.length();
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                if (start + tHeader < headerLen) {
                    try {
                        start += this.getLineOfOffset(start);
                    }
                    catch (BadLocationException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    try {
                        end += this.getLineOfOffset(end);
                    }
                    catch (BadLocationException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    if (end > headerLen) {
                        end = headerLen;
                    }
                    matches.add(new SearchMatch(SearchMatch.Location.RESPONSE_HEAD, start, end));
                    continue;
                }
                matches.add(new SearchMatch(SearchMatch.Location.RESPONSE_BODY, start += tHeader - headerLen, end += tHeader - headerLen));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            int len;
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)sm.getLocation()) && !SearchMatch.Location.RESPONSE_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            boolean isBody = SearchMatch.Location.RESPONSE_BODY.equals((Object)sm.getLocation());
            int t = 0;
            String header = sm.getMessage().getResponseHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && (isBody || (pos += 2) <= sm.getStart())) {
                ++t;
            }
            int start = sm.getStart() - t;
            int end = sm.getEnd() - t;
            if (isBody) {
                start += header.length();
                end += header.length();
            }
            if (start > (len = this.getText().length()) || end > len) {
                return;
            }
            this.highlight(start, end);
        }

        @Override
        protected String detectSyntax(HttpMessage httpMessage) {
            String contentType;
            String syntax = null;
            if (httpMessage != null && (contentType = httpMessage.getResponseHeader().getHeader("Content-Type")) != null && !contentType.isEmpty()) {
                int pos = (contentType = contentType.toLowerCase(Locale.ENGLISH)).indexOf(59);
                if (pos != -1) {
                    contentType = contentType.substring(0, pos).trim();
                }
                syntax = contentType.contains("javascript") ? "text/javascript" : (contentType.contains("json") ? "text/json" : (contentType.contains("xhtml") ? "text/html" : (contentType.contains("xml") ? "text/xml" : contentType)));
            }
            return syntax;
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new ResponseAllTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class ResponseAllTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
            public ResponseAllTokenMakerFactory() {
                String pkg = "org.fife.ui.rsyntaxtextarea.modes.";
                this.putMapping("text/css", pkg + "CSSTokenMaker");
                this.putMapping("text/html", pkg + "HTMLTokenMaker");
                this.putMapping("text/javascript", pkg + "JavaScriptTokenMaker");
                this.putMapping("text/json", pkg + "JsonTokenMaker");
                this.putMapping("text/xml", pkg + "XMLTokenMaker");
            }
        }
    }
}

