/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.all.request;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.CaretVisibilityEnforcerOnFocusGain;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.model.DefaultTextHttpMessageLocation;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;
import org.zaproxy.zap.view.messagecontainer.http.SelectableContentHttpMessageContainer;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListenerAdapter;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightsManager;

public class HttpRequestAllPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView
implements SelectableContentHttpMessageContainer {
    public static final String NAME = "HttpRequestSyntaxTextView";
    private MessageLocationProducerFocusListenerAdapter focusListenerAdapter;

    public HttpRequestAllPanelSyntaxHighlightTextView(RequestStringHttpPanelViewModel model) {
        super(model);
        this.getHttpPanelTextArea().setComponentPopupMenu(new HttpPanelSyntaxHighlightTextView.CustomPopupMenu(){
            private static final long serialVersionUID = 377256890518967680L;

            @Override
            public void show(Component invoker, int x, int y) {
                if (!HttpRequestAllPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().isFocusOwner()) {
                    HttpRequestAllPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().requestFocusInWindow();
                }
                View.getSingleton().getPopupMenu().show(HttpRequestAllPanelSyntaxHighlightTextView.this, x, y);
            }
        });
    }

    @Override
    protected HttpRequestAllPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpRequestAllPanelSyntaxHighlightTextArea();
    }

    @Override
    protected HttpRequestAllPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return (HttpRequestAllPanelSyntaxHighlightTextArea)super.getHttpPanelTextArea();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public Class<? extends MessageLocation> getMessageLocationClass() {
        return TextHttpMessageLocation.class;
    }

    @Override
    public MessageLocation getSelection() {
        return this.getHttpPanelTextArea().getSelection();
    }

    @Override
    public MessageLocationHighlightsManager create() {
        return this.getHttpPanelTextArea().create();
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (!this.supports(location)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, new TextMessageLocationHighlight(Color.LIGHT_GRAY));
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (!this.supports(location) || !(highlight instanceof TextMessageLocationHighlight)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        TextMessageLocationHighlight textHighlight = (TextMessageLocationHighlight)highlight;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, textHighlight);
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (!(highlightReference instanceof TextMessageLocationHighlight)) {
            return;
        }
        this.getHttpPanelTextArea().removeHighlight(((TextMessageLocationHighlight)highlightReference).getHighlightReference());
    }

    @Override
    public boolean supports(MessageLocation location) {
        if (!(location instanceof TextHttpMessageLocation)) {
            return false;
        }
        HttpMessageLocation.Location msgLocation = ((TextHttpMessageLocation)location).getLocation();
        return msgLocation == HttpMessageLocation.Location.REQUEST_HEADER || msgLocation == HttpMessageLocation.Location.REQUEST_BODY;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        return TextHttpMessageLocation.class.isAssignableFrom(classLocation);
    }

    @Override
    public void addFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().removeFocusListener(focusListener);
        if (!this.getFocusListenerAdapter().hasFocusListeners()) {
            this.getHttpPanelTextArea().removeFocusListener(this.focusListenerAdapter);
            this.focusListenerAdapter = null;
        }
    }

    @Override
    public HttpMessage getMessage() {
        return this.getHttpPanelTextArea().getMessage();
    }

    @Override
    public Component getComponent() {
        return this.getHttpPanelTextArea();
    }

    @Override
    public boolean isEmpty() {
        return this.getHttpPanelTextArea().getMessage() == null;
    }

    private MessageLocationProducerFocusListenerAdapter getFocusListenerAdapter() {
        if (this.focusListenerAdapter == null) {
            this.focusListenerAdapter = new MessageLocationProducerFocusListenerAdapter(this);
            this.getHttpPanelTextArea().addFocusListener(this.focusListenerAdapter);
        }
        return this.focusListenerAdapter;
    }

    protected static class HttpRequestAllPanelSyntaxHighlightTextArea
    extends HttpPanelSyntaxHighlightTextArea {
        private static final long serialVersionUID = 923466158533211593L;
        private static final Logger log = Logger.getLogger(HttpRequestAllPanelSyntaxHighlightTextArea.class);
        private static RequestAllTokenMakerFactory tokenMakerFactory = null;
        private CaretVisibilityEnforcerOnFocusGain caretVisiblityEnforcer = new CaretVisibilityEnforcerOnFocusGain((JTextComponent)((Object)this));

        @Override
        public HttpMessage getMessage() {
            return (HttpMessage)super.getMessage();
        }

        @Override
        public void setMessage(Message aMessage) {
            super.setMessage(aMessage);
            this.caretVisiblityEnforcer.setEnforceVisibilityOnFocusGain(aMessage != null);
        }

        protected MessageLocation getSelection() {
            HttpMessageLocation.Location location;
            HttpMessage httpMessage = this.getMessage();
            int tHeader = 0;
            String header = httpMessage.getRequestHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1) {
                pos += 2;
                ++tHeader;
            }
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            int headerLen = header.length();
            if (start + tHeader < headerLen) {
                try {
                    start += this.getLineOfOffset(start);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
                }
                try {
                    end += this.getLineOfOffset(end);
                }
                catch (BadLocationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
                }
                if (end > headerLen) {
                    end = headerLen;
                }
                location = HttpMessageLocation.Location.REQUEST_HEADER;
            } else {
                start += tHeader - headerLen;
                end += tHeader - headerLen;
                location = HttpMessageLocation.Location.REQUEST_BODY;
            }
            try {
                return new DefaultTextHttpMessageLocation(location, start, end, this.getText(start, end - start));
            }
            catch (BadLocationException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
            }
        }

        protected MessageLocationHighlightsManager create() {
            return new TextMessageLocationHighlightsManager();
        }

        protected MessageLocationHighlight highlightImpl(TextHttpMessageLocation textLocation, TextMessageLocationHighlight textHighlight) {
            int len;
            if (this.getMessage() == null) {
                return null;
            }
            boolean isBody = HttpMessageLocation.Location.REQUEST_BODY.equals((Object)textLocation.getLocation());
            int t = 0;
            String header = this.getMessage().getRequestHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && (isBody || (pos += 2) <= textLocation.getStart())) {
                ++t;
            }
            int start = textLocation.getStart() - t;
            int end = textLocation.getEnd() - t;
            if (isBody) {
                start += header.length();
                end += header.length();
            }
            if (start > (len = this.getText().length()) || end > len) {
                return null;
            }
            textHighlight.setHighlightReference(this.highlight(start, end, textHighlight));
            return textHighlight;
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            HttpMessage httpMessage = this.getMessage();
            int tHeader = 0;
            String header = httpMessage.getRequestHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1) {
                pos += 2;
                ++tHeader;
            }
            int headerLen = header.length();
            int diff = tHeader - headerLen;
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                if (start + tHeader < headerLen) {
                    try {
                        start += this.getLineOfOffset(start);
                    }
                    catch (BadLocationException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    try {
                        end += this.getLineOfOffset(end);
                    }
                    catch (BadLocationException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    if (end > headerLen) {
                        end = headerLen;
                    }
                    matches.add(new SearchMatch(SearchMatch.Location.REQUEST_HEAD, start, end));
                    continue;
                }
                matches.add(new SearchMatch(SearchMatch.Location.REQUEST_BODY, start += diff, end += diff));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            int len;
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation()) && !SearchMatch.Location.REQUEST_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            boolean isBody = SearchMatch.Location.REQUEST_BODY.equals((Object)sm.getLocation());
            int t = 0;
            String header = sm.getMessage().getRequestHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && (isBody || (pos += 2) <= sm.getStart())) {
                ++t;
            }
            int start = sm.getStart() - t;
            int end = sm.getEnd() - t;
            if (isBody) {
                start += header.length();
                end += header.length();
            }
            if (start > (len = this.getText().length()) || end > len) {
                return;
            }
            this.highlight(start, end);
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new RequestAllTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class RequestAllTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
        }
    }
}

