/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component.all.response;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.response.ResponseStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextArea;
import org.zaproxy.zap.extension.httppanel.view.text.HttpPanelTextView;
import org.zaproxy.zap.extension.search.SearchMatch;

public class HttpResponseAllPanelTextView
extends HttpPanelTextView {
    private static final Logger log = Logger.getLogger(HttpResponseAllPanelTextView.class);

    public HttpResponseAllPanelTextView(ResponseStringHttpPanelViewModel model) {
        super(model);
    }

    @Override
    protected HttpPanelTextArea createHttpPanelTextArea() {
        return new HttpResponseAllPanelTextArea();
    }

    protected static class HttpResponseAllPanelTextArea
    extends HttpPanelTextArea {
        private static final long serialVersionUID = 2539870692549575745L;

        protected HttpResponseAllPanelTextArea() {
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            HttpMessage httpMessage = (HttpMessage)this.getMessage();
            int tHeader = 0;
            String header = httpMessage.getResponseHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1) {
                pos += 2;
                ++tHeader;
            }
            int headerLen = header.length();
            int diff = tHeader - headerLen;
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                if (start + tHeader < headerLen) {
                    try {
                        start += this.getLineOfOffset(start);
                    }
                    catch (BadLocationException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    try {
                        end += this.getLineOfOffset(end);
                    }
                    catch (BadLocationException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return;
                    }
                    if (end > headerLen) {
                        end = headerLen;
                    }
                    matches.add(new SearchMatch(SearchMatch.Location.RESPONSE_HEAD, start, end));
                    continue;
                }
                matches.add(new SearchMatch(SearchMatch.Location.RESPONSE_BODY, start += diff, end += diff));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            int len;
            if (!SearchMatch.Location.RESPONSE_HEAD.equals((Object)sm.getLocation()) && !SearchMatch.Location.RESPONSE_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            boolean isBody = SearchMatch.Location.RESPONSE_BODY.equals((Object)sm.getLocation());
            int t = 0;
            String header = sm.getMessage().getResponseHeader().toString();
            int pos = 0;
            while ((pos = header.indexOf("\r\n", pos)) != -1 && (isBody || (pos += 2) <= sm.getStart())) {
                ++t;
            }
            int start = sm.getStart() - t;
            int end = sm.getEnd() - t;
            if (isBody) {
                start += header.length();
                end += header.length();
            }
            if (start > (len = this.getText().length()) || end > len) {
                return;
            }
            this.highlight(start, end);
        }
    }
}

