/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class ExtensionParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(ExtensionParam.class);
    private static final String EXTENSION_BASE_KEY = "extensions";
    private static final String ALL_EXTENSIONS_KEY = "extensions.extension";
    private static final String EXTENSION_NAME_KEY = "name";
    private static final String EXTENSION_ENABLED_KEY = "enabled";
    private List<ExtensionState> extensions = Collections.emptyList();

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_EXTENSIONS_KEY);
            this.extensions = new ArrayList<ExtensionState>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(EXTENSION_NAME_KEY, "");
                boolean enabled = sub.getBoolean(EXTENSION_ENABLED_KEY, true);
                this.extensions.add(new ExtensionState(name, enabled));
            }
        }
        catch (ConversionException e) {
            LOGGER.error((Object)("Error while loading extensions' state: " + e.getMessage()), (Throwable)e);
            this.extensions = Collections.emptyList();
        }
    }

    List<ExtensionState> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    void setExtensions(List<ExtensionState> extensionsState) {
        if (extensionsState == null) {
            throw new IllegalArgumentException("Parameter extensionsState must not be null.");
        }
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_EXTENSIONS_KEY);
        for (int i = 0; i < extensionsState.size(); ++i) {
            ExtensionState elem = extensionsState.get(i);
            if (elem.isEnabled()) continue;
            String elementBaseKey = "extensions.extension(" + i + ").";
            this.getConfig().setProperty(elementBaseKey + EXTENSION_NAME_KEY, (Object)elem.getName());
            this.getConfig().setProperty(elementBaseKey + EXTENSION_ENABLED_KEY, (Object)elem.isEnabled());
        }
        this.extensions = extensionsState;
    }

    static class ExtensionState {
        private final String name;
        private final boolean enabled;

        public ExtensionState(String name, boolean enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

