/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.encoder2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.encoder2.EncodeDecodeParam;
import org.zaproxy.zap.utils.FontUtils;

public class EncodeDecodeParamPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -6357927982804314157L;
    private static final String NAME = Constant.messages.getString("enc2.optionspanel.name");
    private static final String NAME_BASE64 = Constant.messages.getString("enc2.optionspanel.base64");
    private static final String CHARSET_LABEL = Constant.messages.getString("enc2.optionspanel.base64.charset");
    private static final String BREAK_LINES_LABEL = Constant.messages.getString("enc2.optionspanel.base64.breaklines");
    private static final String[] CHARSETS = new String[]{"ISO-8859-1", "US-ASCII", "UTF-8"};
    private JComboBox<String> comboBoxBase64Charset;
    private JCheckBox checkBoxBase64DoBreakLines;
    private JPanel base64Panel;

    public EncodeDecodeParamPanel() {
        this.setName(NAME);
        this.setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.add((Component)this.getBase64Panel(), "North");
        this.add(panel);
    }

    private JPanel getBase64Panel() {
        if (this.base64Panel == null) {
            this.base64Panel = new JPanel();
            this.base64Panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            this.base64Panel.setBorder(BorderFactory.createTitledBorder(null, NAME_BASE64, 0, 0, FontUtils.getFont(FontUtils.Size.standard), Color.black));
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 0.5;
            this.base64Panel.add((Component)new JLabel(CHARSET_LABEL), gbc);
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.ipadx = 50;
            this.base64Panel.add(this.getComboBoxBase64Charset(), gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.ipadx = 0;
            this.base64Panel.add((Component)new JLabel(BREAK_LINES_LABEL), gbc);
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.ipadx = 50;
            this.base64Panel.add((Component)this.getCheckBoxBoxBase64DoBreakLines(), gbc);
        }
        return this.base64Panel;
    }

    private JComboBox<String> getComboBoxBase64Charset() {
        if (this.comboBoxBase64Charset == null) {
            this.comboBoxBase64Charset = new JComboBox<String>(new DefaultComboBoxModel<String>(CHARSETS));
        }
        return this.comboBoxBase64Charset;
    }

    private JCheckBox getCheckBoxBoxBase64DoBreakLines() {
        if (this.checkBoxBase64DoBreakLines == null) {
            this.checkBoxBase64DoBreakLines = new JCheckBox();
        }
        return this.checkBoxBase64DoBreakLines;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        EncodeDecodeParam param = options.getParamSet(EncodeDecodeParam.class);
        this.comboBoxBase64Charset.setSelectedItem(param.getBase64Charset());
        this.checkBoxBase64DoBreakLines.setSelected(param.isBase64DoBreakLines());
    }

    @Override
    public void validateParam(Object obj) throws Exception {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        EncodeDecodeParam param = options.getParamSet(EncodeDecodeParam.class);
        param.setBase64Charset((String)this.comboBoxBase64Charset.getSelectedItem());
        param.setBase64DoBreakLines(this.checkBoxBase64DoBreakLines.isSelected());
    }

    @Override
    public String getHelpIndex() {
        return null;
    }
}

