/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk.impl.http;

import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHistoryReferenceContainer;
import org.zaproxy.zap.view.popup.PopupMenuItemHttpMessageContainer;

public class PopupMenuAddBreakHistory
extends PopupMenuItemHistoryReferenceContainer {
    private static final long serialVersionUID = -1984801437717248474L;
    private static final Logger logger = Logger.getLogger(PopupMenuAddBreakHistory.class);
    private final ExtensionBreak extension;

    public PopupMenuAddBreakHistory(ExtensionBreak extension) {
        super(Constant.messages.getString("brk.add.popup"));
        this.extension = extension;
    }

    @Override
    public boolean isEnableForInvoker(PopupMenuItemHttpMessageContainer.Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return invoker == PopupMenuItemHttpMessageContainer.Invoker.HISTORY_PANEL;
    }

    @Override
    public boolean isButtonEnabledForHistoryReference(HistoryReference href) {
        return this.extension.canAddBreakpoint() && super.isButtonEnabledForHistoryReference(href);
    }

    @Override
    public void performAction(HistoryReference href) {
        try {
            this.extension.addUiBreakpoint(href.getHttpMessage());
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.extension.getView().showWarningDialog(Constant.messages.getString("brk.add.error.history"));
        }
    }
}

