/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.brk.BreakAPI;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointMessageHandler;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.brk.BreakpointsOptionsPanel;
import org.zaproxy.zap.extension.brk.BreakpointsPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.extension.brk.BreakpointsTableModel;
import org.zaproxy.zap.extension.brk.BreakpointsUiManagerInterface;
import org.zaproxy.zap.extension.brk.PopupMenuEditBreak;
import org.zaproxy.zap.extension.brk.PopupMenuRemove;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointMessage;
import org.zaproxy.zap.extension.brk.impl.http.HttpBreakpointsUiManagerInterface;
import org.zaproxy.zap.extension.brk.impl.http.ProxyListenerBreak;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionBreak
extends ExtensionAdaptor
implements SessionChangedListener,
OptionsChangedListener {
    public static final String NAME = "ExtensionBreak";
    private static final Logger logger = Logger.getLogger(ExtensionBreak.class);
    private BreakPanel breakPanel = null;
    private ProxyListenerBreak proxyListener = null;
    private BreakpointsPanel breakpointsPanel = null;
    private PopupMenuEditBreak popupMenuEditBreak = null;
    private PopupMenuRemove popupMenuRemove = null;
    private BreakpointMessageHandler breakpointMessageHandler;
    private DialogType currentDialogType = DialogType.NONE;
    private Map<Class<? extends BreakpointMessageInterface>, BreakpointsUiManagerInterface> mapBreakpointUiManager;
    private Map<Class<? extends Message>, BreakpointsUiManagerInterface> mapMessageUiManager;
    private Control.Mode mode = Control.getSingleton().getMode();
    private BreakpointsParam breakpointsParams;
    private BreakpointsOptionsPanel breakpointsOptionsPanel;
    private HttpBreakpointsUiManagerInterface httpBreakpoints;
    private ZapMenuItem menuBreakOnRequests = null;
    private ZapMenuItem menuBreakOnResponses = null;
    private ZapMenuItem menuStep = null;
    private ZapMenuItem menuContinue = null;
    private ZapMenuItem menuDrop = null;
    private ZapMenuItem menuHttpBreakpoint = null;
    private BreakAPI api = new BreakAPI(this);

    public ExtensionBreak() {
        this.initialize();
    }

    public ExtensionBreak(String name) {
        super(name);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(24);
    }

    public BreakPanel getBreakPanel() {
        if (this.breakPanel == null) {
            this.breakPanel = new BreakPanel(this, this.getOptionsParam());
            this.breakPanel.setName(Constant.messages.getString("tab.break"));
        }
        return this.breakPanel;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getOptionsParam());
        if (this.getView() != null) {
            this.breakpointMessageHandler = new BreakpointMessageHandler(this.getBreakPanel());
            this.breakpointMessageHandler.setEnabledBreakpoints(this.getBreakpointsModel().getBreakpointsEnabledList());
            ExtensionHookView pv = extensionHook.getHookView();
            pv.addWorkPanel(this.getBreakPanel());
            pv.addOptionPanel(this.getOptionsPanel());
            extensionHook.getHookMenu().addAnalyseMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookView().addStatusPanel(this.getBreakpointsPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuEdit());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuDelete());
            this.mapBreakpointUiManager = new HashMap<Class<? extends BreakpointMessageInterface>, BreakpointsUiManagerInterface>();
            this.mapMessageUiManager = new HashMap<Class<? extends Message>, BreakpointsUiManagerInterface>();
            this.httpBreakpoints = new HttpBreakpointsUiManagerInterface(extensionHook.getHookMenu(), this);
            this.addBreakpointsUiManager(this.httpBreakpoints);
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToggleBreakOnRequests());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToggleBreakOnResponses());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuStep());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuContinue());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuDrop());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuAddHttpBreakpoint());
            extensionHook.addProxyListener(this.getProxyListenerBreak());
            API.getInstance().registerApiImplementor(this.api);
            extensionHook.addSessionListener(this);
            extensionHook.addOptionsChangedListener(this);
            ExtensionHelp.enableHelpKey(this.getBreakPanel(), "ui.tabs.break");
            ExtensionHelp.enableHelpKey(this.getBreakpointsPanel(), "ui.tabs.breakpoints");
        }
    }

    private BreakpointsParam getOptionsParam() {
        if (this.breakpointsParams == null) {
            this.breakpointsParams = new BreakpointsParam();
        }
        return this.breakpointsParams;
    }

    private BreakpointsOptionsPanel getOptionsPanel() {
        if (this.breakpointsOptionsPanel == null) {
            this.breakpointsOptionsPanel = new BreakpointsOptionsPanel();
        }
        return this.breakpointsOptionsPanel;
    }

    private BreakpointsPanel getBreakpointsPanel() {
        if (this.breakpointsPanel == null) {
            this.breakpointsPanel = new BreakpointsPanel(this);
        }
        return this.breakpointsPanel;
    }

    public void addBreakpoint(BreakpointMessageInterface breakpoint) {
        this.getBreakpointsPanel().addBreakpoint(breakpoint);
        this.getBreakpointsPanel().setTabFocus();
    }

    public void editBreakpoint(BreakpointMessageInterface oldBreakpoint, BreakpointMessageInterface newBreakpoint) {
        this.getBreakpointsPanel().editBreakpoint(oldBreakpoint, newBreakpoint);
    }

    public void removeBreakpoint(BreakpointMessageInterface breakpoint) {
        this.getBreakpointsPanel().removeBreakpoint(breakpoint);
    }

    public List<BreakpointMessageInterface> getBreakpointsList() {
        return this.getBreakpointsModel().getBreakpointsList();
    }

    public BreakpointMessageInterface getUiSelectedBreakpoint() {
        return this.getBreakpointsPanel().getSelectedBreakpoint();
    }

    public void addBreakpointsUiManager(BreakpointsUiManagerInterface uiManager) {
        this.mapBreakpointUiManager.put(uiManager.getBreakpointClass(), uiManager);
        this.mapMessageUiManager.put(uiManager.getMessageClass(), uiManager);
    }

    public void removeBreakpointsUiManager(BreakpointsUiManagerInterface uiManager) {
        this.mapBreakpointUiManager.remove(uiManager.getBreakpointClass());
        this.mapMessageUiManager.remove(uiManager.getMessageClass());
    }

    public void setBreakAllRequests(boolean brk) {
        this.getBreakPanel().setBreakAllRequests(brk);
    }

    public void setBreakAllResponses(boolean brk) {
        this.getBreakPanel().setBreakAllResponses(brk);
    }

    public void addHttpBreakpoint(String string, String location, String match, boolean inverse, boolean ignoreCase) {
        HttpBreakpointMessage.Match mtch;
        HttpBreakpointMessage.Location loc;
        try {
            loc = HttpBreakpointMessage.Location.valueOf(location);
        }
        catch (Exception e) {
            throw new InvalidParameterException("location must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Location.values()));
        }
        try {
            mtch = HttpBreakpointMessage.Match.valueOf(match);
        }
        catch (Exception e) {
            throw new InvalidParameterException("match must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Match.values()));
        }
        this.addBreakpoint(new HttpBreakpointMessage(string, loc, mtch, inverse, ignoreCase));
    }

    public void removeHttpBreakpoint(String string, String location, String match, boolean inverse, boolean ignoreCase) {
        HttpBreakpointMessage.Match mtch;
        HttpBreakpointMessage.Location loc;
        try {
            loc = HttpBreakpointMessage.Location.valueOf(location);
        }
        catch (Exception e) {
            throw new InvalidParameterException("location must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Location.values()));
        }
        try {
            mtch = HttpBreakpointMessage.Match.valueOf(match);
        }
        catch (Exception e) {
            throw new InvalidParameterException("match must be one of " + Arrays.toString((Object[])HttpBreakpointMessage.Match.values()));
        }
        this.removeBreakpoint(new HttpBreakpointMessage(string, loc, mtch, inverse, ignoreCase));
    }

    public void addUiBreakpoint(Message aMessage) {
        BreakpointsUiManagerInterface uiManager = this.getBreakpointUiManager(aMessage.getClass());
        if (uiManager != null) {
            uiManager.handleAddBreakpoint(aMessage);
        }
    }

    private BreakpointsUiManagerInterface getBreakpointUiManager(Class<?> clazz) {
        if (!Message.class.isAssignableFrom(clazz)) {
            return null;
        }
        BreakpointsUiManagerInterface uiManager = this.mapMessageUiManager.get(clazz);
        if (uiManager == null) {
            uiManager = this.getBreakpointUiManager(clazz.getSuperclass());
        }
        return uiManager;
    }

    public void editUiSelectedBreakpoint() {
        BreakpointsUiManagerInterface uiManager;
        BreakpointMessageInterface breakpoint = this.getBreakpointsPanel().getSelectedBreakpoint();
        if (breakpoint != null && (uiManager = this.mapBreakpointUiManager.get(breakpoint.getClass())) != null) {
            uiManager.handleEditBreakpoint(breakpoint);
        }
    }

    public void removeUiSelectedBreakpoint() {
        BreakpointsUiManagerInterface uiManager;
        BreakpointMessageInterface breakpoint = this.getBreakpointsPanel().getSelectedBreakpoint();
        if (breakpoint != null && (uiManager = this.mapBreakpointUiManager.get(breakpoint.getClass())) != null) {
            uiManager.handleRemoveBreakpoint(breakpoint);
        }
    }

    private BreakpointsTableModel getBreakpointsModel() {
        return (BreakpointsTableModel)this.getBreakpointsPanel().getBreakpoints().getModel();
    }

    private ProxyListenerBreak getProxyListenerBreak() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerBreak(this.getModel(), this);
        }
        return this.proxyListener;
    }

    private PopupMenuEditBreak getPopupMenuEdit() {
        if (this.popupMenuEditBreak == null) {
            this.popupMenuEditBreak = new PopupMenuEditBreak();
            this.popupMenuEditBreak.setExtension(this);
        }
        return this.popupMenuEditBreak;
    }

    private PopupMenuRemove getPopupMenuDelete() {
        if (this.popupMenuRemove == null) {
            this.popupMenuRemove = new PopupMenuRemove();
            this.popupMenuRemove.setExtension(this);
        }
        return this.popupMenuRemove;
    }

    private ZapMenuItem getMenuToggleBreakOnRequests() {
        if (this.menuBreakOnRequests == null) {
            this.menuBreakOnRequests = new ZapMenuItem("menu.tools.brk.req", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuBreakOnRequests.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.getOptionsParam().getButtonMode() == 1) {
                        ExtensionBreak.this.getBreakPanel().setBreakAll(!ExtensionBreak.this.getBreakPanel().isBreakAll());
                    } else {
                        ExtensionBreak.this.getBreakPanel().setBreakAllRequests(!ExtensionBreak.this.getBreakPanel().isBreakRequest());
                    }
                }
            });
        }
        return this.menuBreakOnRequests;
    }

    private ZapMenuItem getMenuToggleBreakOnResponses() {
        if (this.menuBreakOnResponses == null) {
            this.menuBreakOnResponses = new ZapMenuItem("menu.tools.brk.resp", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8, false));
            this.menuBreakOnResponses.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.getOptionsParam().getButtonMode() == 1) {
                        ExtensionBreak.this.getBreakPanel().setBreakAll(!ExtensionBreak.this.getBreakPanel().isBreakAll());
                    } else {
                        ExtensionBreak.this.getBreakPanel().setBreakAllResponses(!ExtensionBreak.this.getBreakPanel().isBreakResponse());
                    }
                }
            });
        }
        return this.menuBreakOnResponses;
    }

    private ZapMenuItem getMenuStep() {
        if (this.menuStep == null) {
            this.menuStep = new ZapMenuItem("menu.tools.brk.step", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuStep.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.getBreakPanel().isHoldMessage()) {
                        ExtensionBreak.this.getBreakPanel().step();
                    }
                }
            });
        }
        return this.menuStep;
    }

    private ZapMenuItem getMenuContinue() {
        if (this.menuContinue == null) {
            this.menuContinue = new ZapMenuItem("menu.tools.brk.cont", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuContinue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.getBreakPanel().isHoldMessage()) {
                        ExtensionBreak.this.getBreakPanel().cont();
                    }
                }
            });
        }
        return this.menuContinue;
    }

    private ZapMenuItem getMenuDrop() {
        if (this.menuDrop == null) {
            this.menuDrop = new ZapMenuItem("menu.tools.brk.drop", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuDrop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionBreak.this.getBreakPanel().isHoldMessage()) {
                        ExtensionBreak.this.getBreakPanel().drop();
                    }
                }
            });
        }
        return this.menuDrop;
    }

    private ZapMenuItem getMenuAddHttpBreakpoint() {
        if (this.menuHttpBreakpoint == null) {
            this.menuHttpBreakpoint = new ZapMenuItem("menu.tools.brk.custom", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.menuHttpBreakpoint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String url = "";
                    Component c = View.getSingleton().getMainFrame().getFocusOwner();
                    if (c != null) {
                        if (c instanceof JList) {
                            Object sel = ((JList)c).getSelectedValue();
                            try {
                                if (sel != null && sel instanceof HistoryReference && ((HistoryReference)sel).getURI() != null) {
                                    url = ((HistoryReference)sel).getURI().toString();
                                }
                            }
                            catch (Exception exception) {}
                        } else if (c instanceof JTree) {
                            TreePath path = ((JTree)c).getSelectionPath();
                            try {
                                if (path != null && path.getLastPathComponent() instanceof SiteNode) {
                                    url = ((SiteNode)path.getLastPathComponent()).getHistoryReference().getURI().toString();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    ExtensionBreak.this.httpBreakpoints.handleAddBreakpoint(url);
                }
            });
        }
        return this.menuHttpBreakpoint;
    }

    public boolean canAddBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.ADD;
    }

    public boolean canEditBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.EDIT;
    }

    public boolean canRemoveBreakpoint() {
        return this.currentDialogType == DialogType.NONE || this.currentDialogType == DialogType.REMOVE;
    }

    public void dialogShown(DialogType type) {
        this.currentDialogType = type;
    }

    public void dialogClosed() {
        this.currentDialogType = DialogType.NONE;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("brk.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void sessionAboutToChange(Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionAboutToChange();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionBreak.this.sessionAboutToChange();
                    }
                });
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void sessionChanged(Session session) {
        if (this.getView() == null) {
            return;
        }
        this.getBreakPanel().init();
    }

    private void sessionAboutToChange() {
        if (this.getView() == null) {
            return;
        }
        this.getBreakPanel().reset();
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void destroy() {
        if (this.breakPanel != null) {
            this.breakPanel.savePanels();
        }
    }

    public boolean messageReceivedFromClient(Message aMessage) {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return true;
        }
        return this.breakpointMessageHandler.handleMessageReceivedFromClient(aMessage, this.mode.equals((Object)Control.Mode.protect));
    }

    public boolean messageReceivedFromServer(Message aMessage) {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return true;
        }
        return this.breakpointMessageHandler.handleMessageReceivedFromServer(aMessage, this.mode.equals((Object)Control.Mode.protect));
    }

    public List<BreakpointMessageInterface> getBreakpointsEnabledList() {
        if (this.mode.equals((Object)Control.Mode.safe)) {
            return new ArrayList<BreakpointMessageInterface>();
        }
        return this.getBreakpointsModel().getBreakpointsEnabledList();
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        this.mode = mode;
        if (this.getView() == null) {
            return;
        }
        this.getBreakPanel().sessionModeChanged(mode);
    }

    public void setBreakOnId(String id, boolean enable) {
        logger.debug((Object)("setBreakOnId " + id + " " + enable));
        if (enable) {
            this.breakpointMessageHandler.getEnabledKeyBreakpoints().add(id);
        } else {
            this.breakpointMessageHandler.getEnabledKeyBreakpoints().remove(id);
        }
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        this.applyViewOptions(optionsParam);
    }

    private void applyViewOptions(OptionsParam options) {
        if (this.getView() == null) {
            return;
        }
        this.getBreakPanel().setButtonsLocation(options.getViewParam().getBrkPanelViewOption());
        this.getBreakPanel().setButtonMode(options.getParamSet(BreakpointsParam.class).getButtonMode());
    }

    @Override
    public void optionsLoaded() {
        this.applyViewOptions(this.getModel().getOptionsParam());
    }

    public boolean isInScopeOnly() {
        return this.getOptionsParam().isInScopeOnly();
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    public static enum DialogType {
        NONE,
        ADD,
        EDIT,
        REMOVE;

    }
}

