/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.httppanel.Message;

public class BreakpointMessageHandler {
    private static final Logger logger = Logger.getLogger(BreakpointMessageHandler.class);
    protected static final Object semaphore = new Object();
    protected final BreakPanel breakPanel;
    protected List<BreakpointMessageInterface> enabledBreakpoints;
    private List<String> enabledKeyBreakpoints = new ArrayList<String>();

    public List<String> getEnabledKeyBreakpoints() {
        return this.enabledKeyBreakpoints;
    }

    public void setEnabledKeyBreakpoints(List<String> enabledKeyBreakpoints) {
        this.enabledKeyBreakpoints = enabledKeyBreakpoints;
    }

    public BreakpointMessageHandler(BreakPanel aBreakPanel) {
        this.breakPanel = aBreakPanel;
    }

    public void setEnabledBreakpoints(List<BreakpointMessageInterface> breakpoints) {
        this.enabledBreakpoints = breakpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromClient(Message aMessage, boolean onlyIfInScope) {
        if (!this.isBreakpoint(aMessage, true, onlyIfInScope)) {
            return true;
        }
        this.breakPanel.breakpointHit();
        Object object = semaphore;
        synchronized (object) {
            if (this.breakPanel.isHoldMessage()) {
                this.setBreakDisplay(aMessage, true);
                this.waitUntilContinue(true);
            }
        }
        this.clearAndDisableRequest();
        return !this.breakPanel.isToBeDropped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromServer(Message aMessage, boolean onlyIfInScope) {
        if (!this.isBreakpoint(aMessage, false, onlyIfInScope)) {
            return true;
        }
        this.breakPanel.breakpointHit();
        Object object = semaphore;
        synchronized (object) {
            if (this.breakPanel.isHoldMessage()) {
                this.setBreakDisplay(aMessage, false);
                this.waitUntilContinue(false);
            }
        }
        this.clearAndDisableResponse();
        return !this.breakPanel.isToBeDropped();
    }

    private void setBreakDisplay(Message msg, boolean isRequest) {
        this.setHttpDisplay(this.breakPanel, msg, isRequest);
        this.breakPanel.breakpointDisplayed();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().getMainFrame().toFront();
                }
            });
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setHttpDisplay(final BreakPanel breakPanel, final Message msg, final boolean isRequest) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    breakPanel.setMessage(msg, isRequest);
                }
            });
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void waitUntilContinue(final boolean isRequest) {
        while (this.breakPanel.isHoldMessage()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    BreakpointMessageHandler.this.breakPanel.saveMessage(isRequest);
                }
            });
        }
        catch (Exception ie) {
            logger.warn((Object)ie.getMessage(), (Throwable)ie);
        }
    }

    public boolean isBreakpoint(Message aMessage, boolean isRequest, boolean onlyIfInScope) {
        if (aMessage.isForceIntercept()) {
            return true;
        }
        if (onlyIfInScope && !aMessage.isInScope()) {
            return false;
        }
        if (this.isBreakOnAllRequests(aMessage, isRequest)) {
            return true;
        }
        if (this.isBreakOnAllResponses(aMessage, isRequest)) {
            return true;
        }
        if (this.isBreakOnStepping(aMessage, isRequest)) {
            return true;
        }
        return this.isBreakOnEnabledBreakpoint(aMessage, isRequest, onlyIfInScope);
    }

    protected boolean isBreakOnAllRequests(Message aMessage, boolean isRequest) {
        return isRequest && this.breakPanel.isBreakRequest();
    }

    protected boolean isBreakOnAllResponses(Message aMessage, boolean isRequest) {
        return !isRequest && this.breakPanel.isBreakResponse();
    }

    protected boolean isBreakOnStepping(Message aMessage, boolean isRequest) {
        return this.breakPanel.isStepping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBreakOnEnabledBreakpoint(Message aMessage, boolean isRequest, boolean onlyIfInScope) {
        if (this.enabledBreakpoints.isEmpty()) {
            return false;
        }
        List<BreakpointMessageInterface> list = this.enabledBreakpoints;
        synchronized (list) {
            for (BreakpointMessageInterface breakpoint : this.enabledBreakpoints) {
                if (!breakpoint.match(aMessage, isRequest, onlyIfInScope)) continue;
                return true;
            }
        }
        return false;
    }

    private void clearAndDisableRequest() {
        if (EventQueue.isDispatchThread()) {
            this.breakPanel.clearAndDisableRequest();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BreakpointMessageHandler.this.breakPanel.clearAndDisableRequest();
                    }
                });
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void clearAndDisableResponse() {
        if (EventQueue.isDispatchThread()) {
            this.breakPanel.clearAndDisableResponse();
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BreakpointMessageHandler.this.breakPanel.clearAndDisableResponse();
                    }
                });
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

