/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanel;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.view.TabbedPanel2;
import org.zaproxy.zap.view.ZapToggleButton;

public class BreakPanelToolbarFactory {
    private ContinueButtonAction continueButtonAction = new ContinueButtonAction();
    private StepButtonAction stepButtonAction = new StepButtonAction();
    private DropButtonAction dropButtonAction = new DropButtonAction();
    private AddBreakpointButtonAction addBreakpointButtonAction = new AddBreakpointButtonAction();
    private BreakRequestsButtonAction breakRequestsButtonAction = new BreakRequestsButtonAction();
    private BreakResponsesButtonAction breakResponsesButtonAction = new BreakResponsesButtonAction();
    private BreakAllButtonAction breakAllButtonAction = new BreakAllButtonAction();
    private boolean cont = false;
    private boolean step = false;
    private boolean stepping = false;
    private boolean toBeDropped = false;
    private boolean isBreakRequest = false;
    private boolean isBreakResponse = false;
    private boolean isBreakAll = false;
    private BreakPanel breakPanel = null;
    private BreakpointsParam breakpointsParams;
    private int mode = 0;

    public BreakPanelToolbarFactory(BreakpointsParam breakpointsParams, BreakPanel breakPanel) {
        this.breakpointsParams = breakpointsParams;
        this.breakPanel = breakPanel;
    }

    private void setActiveIcon(boolean active) {
        if (active) {
            this.breakPanel.setTabFocus();
        }
        if (this.breakPanel.getParent() instanceof TabbedPanel) {
            TabbedPanel parent = (TabbedPanel)this.breakPanel.getParent();
            if (active) {
                parent.setIconAt(parent.indexOfComponent(this.breakPanel), new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/101.png")));
            } else {
                parent.setIconAt(parent.indexOfComponent(this.breakPanel), new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/101grey.png")));
            }
            if (parent instanceof TabbedPanel2) {
                ((TabbedPanel2)parent).setTabLocked(this.breakPanel, !active);
            }
        }
    }

    public void breakpointHit() {
        this.resetRequestSerialization(true);
        this.setActiveIcon(true);
        this.setContinue(false);
    }

    public boolean isBreakRequest() {
        return this.isBreakRequest || this.isBreakAll;
    }

    public boolean isBreakResponse() {
        return this.isBreakResponse || this.isBreakAll;
    }

    public boolean isBreakAll() {
        return this.isBreakAll;
    }

    public JButton getBtnStep() {
        return new JButton(this.stepButtonAction);
    }

    public JButton getBtnContinue() {
        return new JButton(this.continueButtonAction);
    }

    public JButton getBtnDrop() {
        return new JButton(this.dropButtonAction);
    }

    private int askForDropConfirmation() {
        String title = Constant.messages.getString("brk.dialogue.confirmDropMessage.title");
        String message = Constant.messages.getString("brk.dialogue.confirmDropMessage.message");
        JCheckBox checkBox = new JCheckBox(Constant.messages.getString("brk.dialogue.confirmDropMessage.option.dontAskAgain"));
        String confirmButtonLabel = Constant.messages.getString("brk.dialogue.confirmDropMessage.button.confirm.label");
        String cancelButtonLabel = Constant.messages.getString("brk.dialogue.confirmDropMessage.button.cancel.label");
        int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), new Object[]{message, " ", checkBox}, title, 2, 3, null, new String[]{confirmButtonLabel, cancelButtonLabel}, null);
        if (checkBox.isSelected()) {
            this.breakpointsParams.setConfirmDropMessage(false);
        }
        return option;
    }

    public JToggleButton getBtnBreakRequest() {
        ZapToggleButton btnBreakRequest = new ZapToggleButton(this.breakRequestsButtonAction);
        btnBreakRequest.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/105r.png")));
        btnBreakRequest.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.request.unset"));
        return btnBreakRequest;
    }

    public JToggleButton getBtnBreakResponse() {
        ZapToggleButton btnBreakResponse = new ZapToggleButton(this.breakResponsesButtonAction);
        btnBreakResponse.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/106r.png")));
        btnBreakResponse.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.response.unset"));
        return btnBreakResponse;
    }

    public JToggleButton getBtnBreakAll() {
        ZapToggleButton btnBreakAll = new ZapToggleButton(this.breakAllButtonAction);
        btnBreakAll.setSelectedIcon(new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/151.png")));
        btnBreakAll.setSelectedToolTipText(Constant.messages.getString("brk.toolbar.button.all.unset"));
        return btnBreakAll;
    }

    public JButton getBtnBreakPoint() {
        return new JButton(this.addBreakpointButtonAction);
    }

    public boolean isStepping() {
        return this.stepping;
    }

    private void resetRequestSerialization(boolean forceSerialize) {
        if (Control.getSingleton() == null) {
            return;
        }
        if (forceSerialize || this.isBreakRequest() || this.isBreakResponse() || this.isBreakAll) {
            Control.getSingleton().getProxy().setSerialize(true);
        } else {
            Control.getSingleton().getProxy().setSerialize(false);
        }
    }

    public void setBreakRequest(boolean brk) {
        this.isBreakRequest = brk;
        this.resetRequestSerialization(false);
        this.breakRequestsButtonAction.setSelected(this.isBreakRequest);
    }

    public void setBreakResponse(boolean brk) {
        this.isBreakResponse = brk;
        this.resetRequestSerialization(false);
        this.breakResponsesButtonAction.setSelected(this.isBreakResponse);
    }

    public void setBreakAll(boolean brk) {
        this.isBreakAll = brk;
        if (!brk) {
            this.stepping = false;
        }
        this.resetRequestSerialization(false);
        this.breakAllButtonAction.setSelected(this.isBreakAll);
    }

    private void toggleBreakRequest() {
        this.setBreakRequest(!this.isBreakRequest);
    }

    private void toggleBreakResponse() {
        this.setBreakResponse(!this.isBreakResponse);
    }

    private void toggleBreakAll() {
        this.setBreakAll(!this.isBreakAll);
    }

    public boolean isHoldMessage() {
        if (this.step) {
            this.stepping = true;
            this.step = false;
            return false;
        }
        if (this.cont) {
            this.stepping = false;
            this.resetRequestSerialization(false);
            return false;
        }
        return true;
    }

    public boolean isContinue() {
        return this.cont;
    }

    public void setBreakEnabled(boolean enabled) {
        if (!enabled) {
            this.isBreakRequest = false;
            this.isBreakResponse = false;
            this.isBreakAll = false;
            this.setContinue(true);
        }
        this.breakRequestsButtonAction.setSelected(false);
        this.breakRequestsButtonAction.setEnabled(enabled);
        this.breakResponsesButtonAction.setSelected(false);
        this.breakResponsesButtonAction.setEnabled(enabled);
        this.breakAllButtonAction.setSelected(false);
        this.breakAllButtonAction.setEnabled(enabled);
    }

    protected void setContinue(boolean isContinue) {
        this.cont = isContinue;
        this.stepButtonAction.setEnabled(!isContinue);
        this.continueButtonAction.setEnabled(!isContinue);
        this.dropButtonAction.setEnabled(!isContinue);
        if (isContinue) {
            this.setActiveIcon(false);
        }
    }

    protected void setStep(boolean isStep) {
        this.step = isStep;
        this.stepButtonAction.setEnabled(!isStep);
        this.continueButtonAction.setEnabled(!isStep);
        this.dropButtonAction.setEnabled(!isStep);
        if (isStep) {
            this.setActiveIcon(false);
        }
    }

    protected void drop() {
        if (this.breakpointsParams.isConfirmDropMessage() && this.askForDropConfirmation() != 0) {
            return;
        }
        this.toBeDropped = true;
        this.setContinue(true);
    }

    public boolean isToBeDropped() {
        boolean drop = this.toBeDropped;
        this.toBeDropped = false;
        return drop;
    }

    public void init() {
        this.cont = false;
        this.step = false;
        this.stepping = false;
        this.toBeDropped = false;
        this.isBreakRequest = false;
        this.isBreakResponse = false;
        this.isBreakAll = false;
    }

    public void reset() {
        if (this.isBreakRequest()) {
            this.toggleBreakRequest();
        }
        if (this.isBreakResponse()) {
            this.toggleBreakResponse();
        }
        if (this.isBreakAll()) {
            this.toggleBreakAll();
        }
        this.toBeDropped = true;
        this.setContinue(true);
    }

    public void setButtonMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        if (this.mode == 1) {
            if (this.isBreakAll) {
                this.setBreakAll(false);
                this.setBreakRequest(true);
                this.setBreakResponse(true);
            }
        } else if (this.isBreakRequest || this.isBreakResponse) {
            this.setBreakRequest(false);
            this.setBreakResponse(false);
            this.setBreakAll(true);
        }
        this.mode = mode;
    }

    private static abstract class SelectableAbstractAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SelectableAbstractAction(String name, Icon icon) {
            super(name, icon);
        }

        public void setSelected(boolean selected) {
            this.putValue("SwingSelectedKey", selected);
        }
    }

    private class BreakAllButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakAllButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/152.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.all.set"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakAll();
        }
    }

    private class BreakResponsesButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakResponsesButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/106.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.response.set"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakResponse();
        }
    }

    private class BreakRequestsButtonAction
    extends SelectableAbstractAction {
        private static final long serialVersionUID = 1L;

        public BreakRequestsButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/105.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.request.set"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.toggleBreakRequest();
        }
    }

    private class AddBreakpointButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddBreakpointButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/break_add.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.brkpoint"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.breakPanel.showNewBreakPointDialog();
        }
    }

    private class DropButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DropButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/150.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.bin"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.drop();
        }
    }

    private class StepButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StepButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/143.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.step"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BreakPanelToolbarFactory.this.mode == 1 && !BreakPanelToolbarFactory.this.isBreakAll) {
                BreakPanelToolbarFactory.this.setContinue(true);
            } else {
                BreakPanelToolbarFactory.this.setStep(true);
            }
        }
    }

    private class ContinueButtonAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ContinueButtonAction() {
            super(null, new ImageIcon(BreakPanelToolbarFactory.class.getResource("/resource/icon/16/131.png")));
            this.putValue("ShortDescription", Constant.messages.getString("brk.toolbar.button.cont"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakPanelToolbarFactory.this.setContinue(true);
            BreakPanelToolbarFactory.this.setBreakAll(false);
            BreakPanelToolbarFactory.this.setBreakRequest(false);
            BreakPanelToolbarFactory.this.setBreakResponse(false);
        }
    }
}

