/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.authorization;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.authorization.AuthorizationAPI;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.extension.authorization.ContextAuthorizationPanel;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionAuthorization
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    private static final Logger log = Logger.getLogger(ExtensionAuthorization.class);
    public static final String NAME = "ExtensionAuthorization";
    private Map<Integer, ContextAuthorizationPanel> contextPanelsMap = new HashMap<Integer, ContextAuthorizationPanel>();

    public ExtensionAuthorization() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(205);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        Model.getSingleton().addContextDataFactory(this);
        if (this.getView() != null) {
            this.getView().addContextPanelFactory(this);
        }
        AuthorizationAPI api = new AuthorizationAPI();
        API.getInstance().registerApiImplementor(api);
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextAuthorizationPanel panel = this.contextPanelsMap.get(context.getIndex());
        if (panel == null) {
            panel = new ContextAuthorizationPanel(this, context.getIndex());
            this.contextPanelsMap.put(context.getIndex(), panel);
        }
        return panel;
    }

    @Override
    public void discardContexts() {
        this.contextPanelsMap.clear();
    }

    @Override
    public void discardContext(Context ctx) {
        this.contextPanelsMap.remove(ctx.getIndex());
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            List<String> loadedData = session.getContextDataStrings(context.getIndex(), 230);
            if (loadedData != null && loadedData.size() > 0) {
                int type = Integer.parseInt(loadedData.get(0));
                switch (type) {
                    case 0: {
                        context.setAuthorizationDetectionMethod(BasicAuthorizationDetectionMethod.loadMethodFromSession(session, context.getIndex()));
                    }
                }
            }
        }
        catch (DatabaseException e) {
            log.error((Object)"Unable to load Authorization Detection method.", (Throwable)e);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            int type = context.getAuthorizationDetectionMethod().getMethodUniqueIdentifier();
            session.setContextData(context.getIndex(), 230, Integer.toString(type));
            context.getAuthorizationDetectionMethod().persistMethodToSession(session, context.getIndex());
        }
        catch (DatabaseException e) {
            log.error((Object)"Unable to persist Authorization Detection method.", (Throwable)e);
        }
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public void exportContextData(Context ctx, Configuration config) {
        config.setProperty("context.authorization.type", (Object)ctx.getAuthorizationDetectionMethod().getMethodUniqueIdentifier());
        ctx.getAuthorizationDetectionMethod().exportMethodData(config);
    }

    @Override
    public void importContextData(Context ctx, Configuration config) throws ConfigurationException {
        int type = config.getInt("context.authorization.type");
        switch (type) {
            case 0: {
                ctx.setAuthorizationDetectionMethod(new BasicAuthorizationDetectionMethod(config));
            }
        }
    }
}

