/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.ascan.CategoryTableModel;
import org.zaproxy.zap.utils.DisplayUtils;

public class PolicyCategoryPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JTable tableTest = null;
    private JScrollPane jScrollPane = null;
    private CategoryTableModel categoryTableModel = null;
    private static final int[] width = new int[]{300, 100, 100, 200};
    private int category;

    public PolicyCategoryPanel(int category, PluginFactory pluginFactory, Plugin.AlertThreshold defaultThreshold) {
        this.category = category;
        this.initialize();
        this.getCategoryTableModel().setTable(category, pluginFactory, defaultThreshold);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.setSize(375, 204);
        this.setName("categoryPanel");
        gridBagConstraints11.weightx = 1.0;
        gridBagConstraints11.weighty = 1.0;
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 1;
        gridBagConstraints11.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints11.anchor = 18;
        this.add((Component)this.getJScrollPane(), gridBagConstraints11);
    }

    private JTable getTableTest() {
        if (this.tableTest == null) {
            this.tableTest = new JTable();
            this.tableTest.setModel(this.getCategoryTableModel());
            this.tableTest.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableTest.setIntercellSpacing(new Dimension(1, 1));
            this.tableTest.setAutoCreateRowSorter(true);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
            sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            this.tableTest.getRowSorter().setSortKeys(sortKeys);
            for (int i = 0; i < this.tableTest.getColumnCount() - 1; ++i) {
                Plugin.AlertThreshold[] column = this.tableTest.getColumnModel().getColumn(i);
                column.setPreferredWidth(width[i]);
            }
            JComboBox<String> jcb1 = new JComboBox<String>();
            for (Plugin.AlertThreshold level : Plugin.AlertThreshold.values()) {
                jcb1.addItem(Constant.messages.getString("ascan.policy.level." + level.name().toLowerCase()));
            }
            this.tableTest.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jcb1));
            JComboBox<String> jcb2 = new JComboBox<String>();
            for (Plugin.AttackStrength level : Plugin.AttackStrength.values()) {
                jcb2.addItem(Constant.messages.getString("ascan.policy.level." + level.name().toLowerCase()));
            }
            this.tableTest.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(jcb2));
        }
        return this.tableTest;
    }

    @Override
    public void initParam(Object obj) {
    }

    @Override
    public void validateParam(Object obj) throws Exception {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTableTest());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    private CategoryTableModel getCategoryTableModel() {
        if (this.categoryTableModel == null) {
            this.categoryTableModel = new CategoryTableModel();
        }
        return this.categoryTableModel;
    }

    public void setPluginFactory(PluginFactory pluginFactory, Plugin.AlertThreshold defaultThreshold) {
        this.getCategoryTableModel().setTable(this.category, pluginFactory, defaultThreshold);
        this.modelChanged();
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.scanpolicy";
    }

    public void modelChanged() {
        this.getCategoryTableModel().fireTableDataChanged();
    }
}

