/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Category;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.ascan.ActiveScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.Target;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ActiveScanAPI
extends ApiImplementor {
    private static Logger log = Logger.getLogger(ActiveScanAPI.class);
    private static final String PREFIX = "ascan";
    private static final String ACTION_SCAN = "scan";
    private static final String ACTION_SCAN_AS_USER = "scanAsUser";
    private static final String ACTION_PAUSE_SCAN = "pause";
    private static final String ACTION_RESUME_SCAN = "resume";
    private static final String ACTION_STOP_SCAN = "stop";
    private static final String ACTION_PAUSE_ALL_SCANS = "pauseAllScans";
    private static final String ACTION_RESUME_ALL_SCANS = "resumeAllScans";
    private static final String ACTION_STOP_ALL_SCANS = "stopAllScans";
    private static final String ACTION_REMOVE_SCAN = "removeScan";
    private static final String ACTION_REMOVE_ALL_SCANS = "removeAllScans";
    private static final String ACTION_EXCLUDE_FROM_SCAN = "excludeFromScan";
    private static final String ACTION_CLEAR_EXCLUDED_FROM_SCAN = "clearExcludedFromScan";
    private static final String ACTION_ENABLE_ALL_SCANNERS = "enableAllScanners";
    private static final String ACTION_DISABLE_ALL_SCANNERS = "disableAllScanners";
    private static final String ACTION_ENABLE_SCANNERS = "enableScanners";
    private static final String ACTION_DISABLE_SCANNERS = "disableScanners";
    private static final String ACTION_SET_ENABLED_POLICIES = "setEnabledPolicies";
    private static final String ACTION_SET_POLICY_ATTACK_STRENGTH = "setPolicyAttackStrength";
    private static final String ACTION_SET_POLICY_ALERT_THRESHOLD = "setPolicyAlertThreshold";
    private static final String ACTION_SET_SCANNER_ATTACK_STRENGTH = "setScannerAttackStrength";
    private static final String ACTION_SET_SCANNER_ALERT_THRESHOLD = "setScannerAlertThreshold";
    private static final String ACTION_ADD_SCAN_POLICY = "addScanPolicy";
    private static final String ACTION_REMOVE_SCAN_POLICY = "removeScanPolicy";
    private static final String VIEW_STATUS = "status";
    private static final String VIEW_SCANS = "scans";
    private static final String VIEW_MESSAGES_IDS = "messagesIds";
    private static final String VIEW_ALERTS_IDS = "alertsIds";
    private static final String VIEW_EXCLUDED_FROM_SCAN = "excludedFromScan";
    private static final String VIEW_SCANNERS = "scanners";
    private static final String VIEW_POLICIES = "policies";
    private static final String VIEW_SCAN_POLICY_NAMES = "scanPolicyNames";
    private static final String VIEW_ATTACK_MODE_QUEUE = "attackModeQueue";
    private static final String VIEW_SCAN_PROGRESS = "scanProgress";
    private static final String PARAM_URL = "url";
    private static final String PARAM_CONTEXT_ID = "contextId";
    private static final String PARAM_USER_ID = "userId";
    private static final String PARAM_REGEX = "regex";
    private static final String PARAM_RECURSE = "recurse";
    private static final String PARAM_JUST_IN_SCOPE = "inScopeOnly";
    private static final String PARAM_IDS = "ids";
    private static final String PARAM_ID = "id";
    private static final String PARAM_ATTACK_STRENGTH = "attackStrength";
    private static final String PARAM_ALERT_THRESHOLD = "alertThreshold";
    private static final String PARAM_SCAN_POLICY_NAME = "scanPolicyName";
    private static final String PARAM_CATEGORY_ID = "policyId";
    private static final String PARAM_SCAN_ID = "scanId";
    private static final String PARAM_METHOD = "method";
    private static final String PARAM_POST_DATA = "postData";
    private ExtensionActiveScan controller = null;

    public ActiveScanAPI(ExtensionActiveScan controller) {
        this.controller = controller;
        this.addApiAction(new ApiAction(ACTION_SCAN, new String[]{PARAM_URL}, new String[]{PARAM_RECURSE, PARAM_JUST_IN_SCOPE, PARAM_SCAN_POLICY_NAME, PARAM_METHOD, PARAM_POST_DATA}));
        this.addApiAction(new ApiAction(ACTION_SCAN_AS_USER, new String[]{PARAM_URL, PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_RECURSE, PARAM_SCAN_POLICY_NAME, PARAM_METHOD, PARAM_POST_DATA}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_RESUME_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_STOP_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN, new String[]{PARAM_SCAN_ID}));
        this.addApiAction(new ApiAction(ACTION_PAUSE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_RESUME_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_STOP_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_REMOVE_ALL_SCANS));
        this.addApiAction(new ApiAction(ACTION_CLEAR_EXCLUDED_FROM_SCAN));
        this.addApiAction(new ApiAction(ACTION_EXCLUDE_FROM_SCAN, new String[]{PARAM_REGEX}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_ALL_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_ALL_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_ENABLE_SCANNERS, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_DISABLE_SCANNERS, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED_POLICIES, new String[]{PARAM_IDS}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_POLICY_ATTACK_STRENGTH, new String[]{PARAM_ID, PARAM_ATTACK_STRENGTH}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_POLICY_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ATTACK_STRENGTH, new String[]{PARAM_ID, PARAM_ATTACK_STRENGTH}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_SCANNER_ALERT_THRESHOLD, new String[]{PARAM_ID, PARAM_ALERT_THRESHOLD}, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_ADD_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_SCAN_POLICY, new String[]{PARAM_SCAN_POLICY_NAME}));
        this.addApiView(new ApiView(VIEW_STATUS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCAN_PROGRESS, null, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_MESSAGES_IDS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_ALERTS_IDS, new String[]{PARAM_SCAN_ID}));
        this.addApiView(new ApiView(VIEW_SCANS));
        this.addApiView(new ApiView(VIEW_SCAN_POLICY_NAMES));
        this.addApiView(new ApiView(VIEW_EXCLUDED_FROM_SCAN));
        this.addApiView(new ApiView(VIEW_SCANNERS, null, new String[]{PARAM_SCAN_POLICY_NAME, PARAM_CATEGORY_ID}));
        this.addApiView(new ApiView(VIEW_POLICIES, null, new String[]{PARAM_SCAN_POLICY_NAME, PARAM_CATEGORY_ID}));
        this.addApiView(new ApiView(VIEW_ATTACK_MODE_QUEUE));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug((Object)("handleApiAction " + name + " " + params.toString()));
        User user = null;
        try {
            switch (name) {
                case "scanAsUser": {
                    int userID = ApiUtils.getIntParam(params, PARAM_USER_ID);
                    ExtensionUserManagement usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                    if (usersExtension == null) {
                        throw new ApiException(ApiException.Type.NO_IMPLEMENTOR, "ExtensionUserManagement");
                    }
                    Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                    if (!context.isIncluded(params.getString(PARAM_URL))) {
                        throw new ApiException(ApiException.Type.URL_NOT_IN_CONTEXT, PARAM_CONTEXT_ID);
                    }
                    user = usersExtension.getContextUserAuthManager(context.getIndex()).getUserById(userID);
                    if (user == null) {
                        throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
                    }
                }
                case "scan": {
                    URI url = ActiveScanAPI.getTargetUrl(params.getString(PARAM_URL));
                    boolean scanJustInScope = user == null ? this.getParam(params, PARAM_JUST_IN_SCOPE, false) : false;
                    String policyName = null;
                    ScanPolicy policy = null;
                    try {
                        policyName = params.getString(PARAM_SCAN_POLICY_NAME);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (policyName != null && policyName.length() > 0) {
                            log.debug((Object)("handleApiAction scan policy =" + policyName));
                            policy = this.controller.getPolicyManager().getPolicy(policyName);
                        }
                    }
                    catch (ConfigurationException e) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_POLICY_NAME);
                    }
                    String method = this.getParam(params, PARAM_METHOD, "GET");
                    if (method.trim().length() == 0) {
                        method = "GET";
                    }
                    if (!Arrays.asList(HttpRequestHeader.METHODS).contains(method)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_METHOD);
                    }
                    int scanId = this.scanURL(url, user, this.getParam(params, PARAM_RECURSE, true), scanJustInScope, method, this.getParam(params, PARAM_POST_DATA, ""), policy);
                    return new ApiResponseElement(name, Integer.toString(scanId));
                }
                case "pause": {
                    this.getActiveScan(params).pauseScan();
                    break;
                }
                case "resume": {
                    this.getActiveScan(params).resumeScan();
                    break;
                }
                case "stop": {
                    this.getActiveScan(params).stopScan();
                    break;
                }
                case "removeScan": {
                    ActiveScan activeScan = this.controller.removeScan(params.getInt(PARAM_SCAN_ID));
                    if (activeScan == null) {
                        throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
                    }
                    break;
                }
                case "pauseAllScans": {
                    this.controller.pauseAllScans();
                    break;
                }
                case "resumeAllScans": {
                    this.controller.resumeAllScans();
                    break;
                }
                case "stopAllScans": {
                    this.controller.stopAllScans();
                    break;
                }
                case "removeAllScans": {
                    this.controller.removeAllScans();
                    break;
                }
                case "clearExcludedFromScan": {
                    try {
                        Session session = Model.getSingleton().getSession();
                        session.setExcludeFromScanRegexs(new ArrayList<String>());
                        break;
                    }
                    catch (DatabaseException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                }
                case "excludeFromScan": {
                    String regex = params.getString(PARAM_REGEX);
                    try {
                        Session session = Model.getSingleton().getSession();
                        session.addExcludeFromScanRegexs(regex);
                        break;
                    }
                    catch (DatabaseException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                    }
                    catch (PatternSyntaxException e) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_REGEX);
                    }
                }
                case "enableAllScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    policy.getPluginFactory().setAllPluginEnabled(true);
                    policy.save();
                    break;
                }
                case "disableAllScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    policy.getPluginFactory().setAllPluginEnabled(false);
                    policy.save();
                    break;
                }
                case "enableScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    this.setScannersEnabled(policy, this.getParam(params, PARAM_IDS, "").split(","), true);
                    policy.save();
                    break;
                }
                case "disableScanners": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    this.setScannersEnabled(policy, this.getParam(params, PARAM_IDS, "").split(","), false);
                    policy.save();
                    break;
                }
                case "setEnabledPolicies": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    this.setEnabledPolicies(policy, this.getParam(params, PARAM_IDS, "").split(","));
                    policy.save();
                    break;
                }
                case "setPolicyAttackStrength": {
                    int policyId = this.getPolicyIdFromParamId(params);
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin.AttackStrength attackStrength = this.getAttackStrengthFromParamAttack(params);
                    for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
                        if (scanner.getCategory() != policyId) continue;
                        scanner.setAttackStrength(attackStrength);
                    }
                    policy.save();
                    break;
                }
                case "setPolicyAlertThreshold": {
                    int policyId = this.getPolicyIdFromParamId(params);
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin.AlertThreshold alertThreshold1 = this.getAlertThresholdFromParamAlertThreshold(params);
                    for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
                        if (scanner.getCategory() != policyId) continue;
                        scanner.setAlertThreshold(alertThreshold1);
                    }
                    policy.save();
                    break;
                }
                case "setScannerAttackStrength": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin scanner = this.getScannerFromParamId(policy, params);
                    scanner.setAttackStrength(this.getAttackStrengthFromParamAttack(params));
                    policy.save();
                    break;
                }
                case "setScannerAlertThreshold": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    Plugin.AlertThreshold alertThreshold2 = this.getAlertThresholdFromParamAlertThreshold(params);
                    this.getScannerFromParamId(policy, params).setAlertThreshold(alertThreshold2);
                    policy.save();
                    break;
                }
                case "addScanPolicy": {
                    String newPolicyName = params.getString(PARAM_SCAN_POLICY_NAME);
                    if (this.controller.getPolicyManager().getAllPolicyNames().contains(newPolicyName)) {
                        throw new ApiException(ApiException.Type.ALREADY_EXISTS, PARAM_SCAN_POLICY_NAME);
                    }
                    if (!this.controller.getPolicyManager().isLegalPolicyName(newPolicyName)) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_SCAN_POLICY_NAME);
                    }
                    ScanPolicy policy = this.controller.getPolicyManager().getTemplatePolicy();
                    policy.setName(newPolicyName);
                    this.controller.getPolicyManager().savePolicy(policy);
                    break;
                }
                case "removeScanPolicy": {
                    ScanPolicy policy = this.getScanPolicyFromParams(params);
                    if (this.controller.getPolicyManager().getAllPolicyNames().size() == 1) {
                        throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "You are not allowed to remove the last scan policy");
                    }
                    this.controller.getPolicyManager().deletePolicy(policy.getName());
                    break;
                }
                default: {
                    throw new ApiException(ApiException.Type.BAD_ACTION);
                }
            }
        }
        catch (ConfigurationException e) {
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
        }
        return ApiResponseElement.OK;
    }

    private static URI getTargetUrl(String url) throws ApiException {
        try {
            URI targetUrl = new URI(url, false);
            String scheme = targetUrl.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
            }
            return targetUrl;
        }
        catch (URIException e) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_URL);
        }
    }

    private ScanPolicy getScanPolicyFromParams(JSONObject params) throws ApiException {
        String policyName = null;
        try {
            policyName = params.getString(PARAM_SCAN_POLICY_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (policyName == null || policyName.length() == 0) {
            return this.controller.getPolicyManager().getDefaultScanPolicy();
        }
        try {
            return this.controller.getPolicyManager().getPolicy(policyName);
        }
        catch (ConfigurationException e) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_POLICY_NAME);
        }
    }

    private ActiveScan getActiveScan(JSONObject params) throws ApiException {
        int id = this.getParam(params, PARAM_SCAN_ID, -1);
        ActiveScan activeScan = null;
        activeScan = id == -1 ? this.controller.getLastScan() : this.controller.getScan(id);
        if (activeScan == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_SCAN_ID);
        }
        return activeScan;
    }

    private void setScannersEnabled(ScanPolicy policy, String[] ids, boolean enabled) throws ConfigurationException, ApiException {
        if (ids.length > 0) {
            for (String id : ids) {
                try {
                    Plugin scanner = policy.getPluginFactory().getPlugin(Integer.valueOf(id.trim()));
                    if (scanner == null) continue;
                    scanner.setEnabled(enabled);
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Failed to parse scanner ID: ", (Throwable)e);
                }
            }
        }
    }

    private void setEnabledPolicies(ScanPolicy policy, String[] ids) {
        policy.getPluginFactory().setAllPluginEnabled(false);
        if (ids.length > 0) {
            for (String id : ids) {
                try {
                    int policyId = Integer.valueOf(id.trim());
                    if (!ActiveScanAPI.hasPolicyWithId(policyId)) continue;
                    for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
                        if (scanner.getCategory() != policyId) continue;
                        scanner.setEnabled(true);
                    }
                }
                catch (NumberFormatException e) {
                    log.warn((Object)"Failed to parse policy ID: ", (Throwable)e);
                }
            }
        }
    }

    private static boolean hasPolicyWithId(int policyId) {
        return Arrays.asList(Category.getAllNames()).contains(Category.getName(policyId));
    }

    private int getPolicyIdFromParamId(JSONObject params) throws ApiException {
        int id = this.getParam(params, PARAM_ID, -1);
        if (id == -1) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ID);
        }
        if (!ActiveScanAPI.hasPolicyWithId(id)) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ID);
        }
        return id;
    }

    private Plugin.AttackStrength getAttackStrengthFromParamAttack(JSONObject params) throws ApiException {
        String paramAttackStrength = params.getString(PARAM_ATTACK_STRENGTH).trim().toUpperCase();
        try {
            return Plugin.AttackStrength.valueOf(paramAttackStrength);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ATTACK_STRENGTH);
        }
    }

    private Plugin.AlertThreshold getAlertThresholdFromParamAlertThreshold(JSONObject params) throws ApiException {
        String paramAlertThreshold = params.getString(PARAM_ALERT_THRESHOLD).trim().toUpperCase();
        try {
            return Plugin.AlertThreshold.valueOf(paramAlertThreshold);
        }
        catch (IllegalArgumentException e) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ALERT_THRESHOLD);
        }
    }

    private Plugin getScannerFromParamId(ScanPolicy policy, JSONObject params) throws ApiException {
        int id = this.getParam(params, PARAM_ID, -1);
        if (id == -1) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PARAM_ID);
        }
        Plugin scanner = policy.getPluginFactory().getPlugin(id);
        if (scanner == null) {
            throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_ID);
        }
        return scanner;
    }

    private int scanURL(URI url, User user, boolean scanChildren, boolean scanJustInScope, String method, String postData, ScanPolicy policy) throws ApiException {
        try {
            StructuralNode node = SessionStructure.find(Model.getSingleton().getSession().getSessionId(), url, method, postData);
            if (node == null) {
                throw new ApiException(ApiException.Type.URL_NOT_FOUND);
            }
            switch (Control.getSingleton().getMode()) {
                case safe: {
                    throw new ApiException(ApiException.Type.MODE_VIOLATION);
                }
                case protect: {
                    if (Model.getSingleton().getSession().isInScope(url.toString())) break;
                    throw new ApiException(ApiException.Type.MODE_VIOLATION);
                }
                case standard: {
                    break;
                }
            }
            Target target = new Target(node);
            target.setRecurse(scanChildren);
            target.setInScopeOnly(scanJustInScope);
            if (user != null) {
                target.setContext(user.getContext());
            }
            Object[] objs = new Object[]{};
            if (policy != null) {
                objs = new Object[]{policy};
            }
            return this.controller.startScan(null, target, user, objs);
        }
        catch (ApiException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        ApiResponse result;
        ActiveScan activeScan = null;
        switch (name) {
            case "status": {
                activeScan = this.getActiveScan(params);
                int progress = 0;
                if (activeScan != null) {
                    progress = activeScan.getProgress();
                }
                result = new ApiResponseElement(name, String.valueOf(progress));
                break;
            }
            case "scans": {
                ApiResponseList resultList = new ApiResponseList(name);
                for (GenericScanner2 genericScanner2 : this.controller.getAllScans()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(PARAM_ID, Integer.toString(genericScanner2.getScanId()));
                    map.put("progress", Integer.toString(genericScanner2.getProgress()));
                    map.put("state", ((ActiveScan)genericScanner2).getState().name());
                    resultList.addItem(new ApiResponseSet(ACTION_SCAN, map));
                }
                result = resultList;
                break;
            }
            case "scanProgress": {
                ApiResponseList resultList = new ApiResponseList(name);
                activeScan = this.getActiveScan(params);
                if (activeScan != null) {
                    for (HostProcess hostProcess : activeScan.getHostProcesses()) {
                        ApiResponseList hpList = new ApiResponseList("HostProcess");
                        resultList.addItem(new ApiResponseElement(PARAM_ID, XMLStringUtil.escapeControlChrs(hostProcess.getHostAndPort())));
                        for (Plugin plugin : hostProcess.getCompleted()) {
                            long timeTaken = plugin.getTimeFinished().getTime() - plugin.getTimeStarted().getTime();
                            int reqs = hostProcess.getPluginRequestCount(plugin.getId());
                            hpList.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, "Complete", timeTaken, reqs));
                        }
                        for (Plugin plugin : hostProcess.getRunning()) {
                            int pc = hostProcess.getTestCurrentCount(plugin) * 100 / hostProcess.getTestTotalCount();
                            if (pc >= 100) {
                                pc = 99;
                            }
                            long timeTaken = new Date().getTime() - plugin.getTimeStarted().getTime();
                            int reqs = hostProcess.getPluginRequestCount(plugin.getId());
                            hpList.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, pc + "%", timeTaken, reqs));
                        }
                        for (Plugin plugin : hostProcess.getPending()) {
                            hpList.addItem(ActiveScanAPI.createPluginProgressEntry(plugin, "Pending", 0L, 0));
                        }
                        resultList.addItem(hpList);
                    }
                }
                result = resultList;
                break;
            }
            case "messagesIds": {
                ApiResponseList resultList = new ApiResponseList(name);
                activeScan = this.getActiveScan(params);
                if (activeScan != null) {
                    List<Integer> list = activeScan.getMessagesIds();
                    synchronized (list) {
                        for (Integer id : activeScan.getMessagesIds()) {
                            resultList.addItem(new ApiResponseElement(PARAM_ID, id.toString()));
                        }
                    }
                }
                result = resultList;
                break;
            }
            case "alertsIds": {
                ApiResponseList resultList = new ApiResponseList(name);
                activeScan = this.getActiveScan(params);
                if (activeScan != null) {
                    List<Integer> list = activeScan.getAlertsIds();
                    synchronized (list) {
                        for (Integer id : activeScan.getAlertsIds()) {
                            resultList.addItem(new ApiResponseElement(PARAM_ID, id.toString()));
                        }
                    }
                }
                result = resultList;
                break;
            }
            case "excludedFromScan": {
                result = new ApiResponseList(name);
                Session session = Model.getSingleton().getSession();
                List<String> list = session.getExcludeFromScanRegexs();
                for (String regex : list) {
                    ((ApiResponseList)result).addItem(new ApiResponseElement(PARAM_REGEX, regex));
                }
                break;
            }
            case "scanners": {
                ScanPolicy policy = this.getScanPolicyFromParams(params);
                List<Plugin> scanners = policy.getPluginFactory().getAllPlugin();
                int categoryId = this.getParam(params, PARAM_CATEGORY_ID, -1);
                if (categoryId != -1 && !ActiveScanAPI.hasPolicyWithId(categoryId)) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, PARAM_CATEGORY_ID);
                }
                ApiResponseList resultList = new ApiResponseList(name);
                for (Plugin scanner : scanners) {
                    if (categoryId != -1 && categoryId != scanner.getCategory()) continue;
                    resultList.addItem(new ScannerApiResponse(policy, scanner));
                }
                result = resultList;
                break;
            }
            case "policies": {
                ScanPolicy policy = this.getScanPolicyFromParams(params);
                String[] policies = Category.getAllNames();
                ApiResponseList resultList = new ApiResponseList(name);
                for (String pluginName : policies) {
                    int categoryId = Category.getCategory(pluginName);
                    Plugin.AttackStrength attackStrength = this.getPolicyAttackStrength(policy, categoryId);
                    Plugin.AlertThreshold alertThreshold = this.getPolicyAlertThreshold(policy, categoryId);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(PARAM_ID, String.valueOf(categoryId));
                    map.put("name", pluginName);
                    map.put(PARAM_ATTACK_STRENGTH, attackStrength == null ? "" : String.valueOf((Object)attackStrength));
                    map.put(PARAM_ALERT_THRESHOLD, alertThreshold == null ? "" : String.valueOf((Object)alertThreshold));
                    map.put("enabled", String.valueOf(this.isPolicyEnabled(policy, categoryId)));
                    resultList.addItem(new ApiResponseSet("policy", map));
                }
                result = resultList;
                break;
            }
            case "scanPolicyNames": {
                ApiResponseList resultList = new ApiResponseList(name);
                for (String policyName : this.controller.getPolicyManager().getAllPolicyNames()) {
                    resultList.addItem(new ApiResponseElement("policy", policyName));
                }
                result = resultList;
                break;
            }
            case "attackModeQueue": {
                result = new ApiResponseElement(name, String.valueOf(this.controller.getAttackModeStackSize()));
                break;
            }
            default: {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
        }
        return result;
    }

    private static ApiResponseList createPluginProgressEntry(Plugin plugin, String status, long timeTaken, int requestCount) {
        ApiResponseList pList = new ApiResponseList("Plugin");
        pList.addItem(new ApiResponseElement("name", XMLStringUtil.escapeControlChrs(plugin.getName())));
        pList.addItem(new ApiResponseElement(PARAM_ID, Integer.toString(plugin.getId())));
        pList.addItem(new ApiResponseElement("quality", plugin.getStatus().toString()));
        pList.addItem(new ApiResponseElement(VIEW_STATUS, status));
        pList.addItem(new ApiResponseElement("timeInMs", Long.toString(timeTaken)));
        pList.addItem(new ApiResponseElement("reqCount", Integer.toString(requestCount)));
        return pList;
    }

    private boolean isPolicyEnabled(ScanPolicy policy, int category) {
        for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
            if (scanner.getCategory() != category || scanner.isEnabled()) continue;
            return false;
        }
        return true;
    }

    private Plugin.AttackStrength getPolicyAttackStrength(ScanPolicy policy, int categoryd) {
        Plugin.AttackStrength attackStrength = null;
        for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
            if (scanner.getCategory() != categoryd) continue;
            if (attackStrength == null) {
                attackStrength = scanner.getAttackStrength(true);
                continue;
            }
            if (attackStrength.equals((Object)scanner.getAttackStrength(true))) continue;
            return null;
        }
        return attackStrength;
    }

    private Plugin.AlertThreshold getPolicyAlertThreshold(ScanPolicy policy, int categoryId) {
        Plugin.AlertThreshold alertThreshold = null;
        for (Plugin scanner : policy.getPluginFactory().getAllPlugin()) {
            if (scanner.getCategory() != categoryId) continue;
            if (alertThreshold == null) {
                alertThreshold = scanner.getAlertThreshold(true);
                continue;
            }
            if (alertThreshold.equals((Object)scanner.getAlertThreshold(true))) continue;
            return null;
        }
        return alertThreshold;
    }

    private class ScannerApiResponse
    extends ApiResponse {
        final Map<String, String> scannerData;
        final ApiResponseList dependencies;

        public ScannerApiResponse(ScanPolicy policy, Plugin scanner) {
            super("scanner");
            this.scannerData = new HashMap<String, String>();
            this.scannerData.put(ActiveScanAPI.PARAM_ID, String.valueOf(scanner.getId()));
            this.scannerData.put("name", scanner.getName());
            this.scannerData.put("cweId", String.valueOf(scanner.getCweId()));
            this.scannerData.put("wascId", String.valueOf(scanner.getWascId()));
            this.scannerData.put(ActiveScanAPI.PARAM_ATTACK_STRENGTH, String.valueOf((Object)scanner.getAttackStrength(true)));
            this.scannerData.put(ActiveScanAPI.PARAM_ALERT_THRESHOLD, String.valueOf((Object)scanner.getAlertThreshold(true)));
            this.scannerData.put(ActiveScanAPI.PARAM_CATEGORY_ID, String.valueOf(scanner.getCategory()));
            this.scannerData.put("enabled", String.valueOf(scanner.isEnabled()));
            this.scannerData.put("quality", scanner.getStatus().toString());
            boolean allDepsAvailable = policy.getPluginFactory().hasAllDependenciesAvailable(scanner);
            this.scannerData.put("allDependenciesAvailable", Boolean.toString(allDepsAvailable));
            this.dependencies = new ApiResponseList("dependencies");
            for (Plugin dependency : policy.getPluginFactory().getDependencies(scanner)) {
                this.dependencies.addItem(new ApiResponseElement("dependency", Integer.toString(dependency.getId())));
            }
        }

        @Override
        public void toXML(Document doc, Element parent) {
            parent.setAttribute("type", "set");
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                Element el = doc.createElement(val.getKey());
                el.appendChild(doc.createTextNode(XMLStringUtil.escapeControlChrs(val.getValue())));
                parent.appendChild(el);
            }
            Element el = doc.createElement(this.dependencies.getName());
            this.dependencies.toXML(doc, el);
            parent.appendChild(el);
        }

        @Override
        public JSON toJSON() {
            JSONObject jo = new JSONObject();
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                jo.put((Object)val.getKey(), (Object)val.getValue());
            }
            jo.put((Object)this.dependencies.getName(), (Object)((JSONObject)this.dependencies.toJSON()).getJSONArray(this.dependencies.getName()));
            return jo;
        }

        @Override
        public void toHTML(StringBuilder sb) {
            sb.append("<h2>" + this.getName() + "</h2>\n");
            sb.append("<table border=\"1\">\n");
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                sb.append("<tr><td>\n");
                sb.append(val.getKey());
                sb.append("</td><td>\n");
                sb.append(StringEscapeUtils.escapeHtml((String)val.getValue()));
                sb.append("</td></tr>\n");
            }
            sb.append("<tr><td>\n");
            sb.append(this.dependencies.getName());
            sb.append("</td><td>\n");
            sb.append("<table border=\"1\">\n");
            for (ApiResponse resp : this.dependencies.getItems()) {
                sb.append("<tr><td>\n");
                resp.toHTML(sb);
                sb.append("</td></tr>\n");
            }
            sb.append("</table>\n");
            sb.append("</td></tr>\n");
            sb.append("</table>\n");
        }

        @Override
        public String toString(int indent) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("ScannerApiResponse ");
            sb.append(this.getName());
            sb.append(" : [\n");
            for (Map.Entry<String, String> val : this.scannerData.entrySet()) {
                for (int i = 0; i < indent + 1; ++i) {
                    sb.append("\t");
                }
                sb.append(val.getKey());
                sb.append(" = ");
                sb.append(val.getValue());
                sb.append("\n");
            }
            this.dependencies.toString(indent + 1);
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("]\n");
            return sb.toString();
        }
    }
}

