/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class WikiAPIGenerator {
    private static final String WIKI_FILE_EXTENSION = ".md";
    private String base = "ApiGen_";
    private String title = "# ZAP " + Constant.PROGRAM_VERSION + " API\n";
    private File dir;
    private int methods = 0;
    private boolean optional = false;
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));

    public WikiAPIGenerator() {
        this.dir = new File("../zaproxy-wiki");
    }

    public WikiAPIGenerator(String path, boolean optional) {
        this.dir = new File(path);
        this.optional = optional;
    }

    private void generateWikiIndex() throws IOException {
        File f = new File(this.dir, this.base + "Index" + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + f.getAbsolutePath());
        FileWriter out = new FileWriter(f);
        out.write(this.title);
        out.write("## Components\n");
        for (ApiImplementor imp : ApiGeneratorUtils.getAllImplementors()) {
            out.write("  * [" + this.base + imp.getPrefix() + " " + imp.getPrefix() + "]\n");
        }
        out.write("\n\n[" + this.base + "Full Full list.]\n\n");
        out.close();
    }

    private void generateWikiFull() throws IOException {
        File f = new File(this.dir, this.base + "Full" + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + f.getAbsolutePath());
        FileWriter out = new FileWriter(f);
        out.write(this.title);
        out.write("## Full List\n");
        out.write("| _Component_ | _Name_ | _Type_ | _Parameters_ | _Description_ |\n");
        out.write("|:------------|:-------|:-------|:-------------|:--------------|\n");
        for (ApiImplementor imp : ApiGeneratorUtils.getAllImplementors()) {
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generateWikiElement(apiElement, imp.getPrefix(), "view", out, true);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generateWikiElement(apiElement, imp.getPrefix(), "action", out, true);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generateWikiElement(apiElement, imp.getPrefix(), "other", out, true);
            }
        }
        out.write("\n");
        out.write("Starred parameters are mandatory.\n\n");
        if (this.optional) {
            out.write("This component is optional and therefore the API will only work if it is installed.\n\n");
        }
        out.write("Back to [index](" + this.base + "Index)\n\n");
        out.close();
    }

    public void generateWikiFiles(List<ApiImplementor> implementors) throws IOException {
        this.generateWikiIndex();
        for (ApiImplementor imp : implementors) {
            this.generateWikiComponent(imp);
        }
        this.methods = 0;
        this.generateWikiFull();
        System.out.println("Generated a total of " + this.methods + " methods");
    }

    private void generateWikiElement(ApiElement element, String component, String type, Writer out) throws IOException {
        this.generateWikiElement(element, component, type, out, false);
    }

    private void generateWikiElement(ApiElement element, String component, String type, Writer out, boolean incComponentCol) throws IOException {
        if (incComponentCol) {
            out.write("| " + component);
        }
        out.write("| " + element.getName() + "| " + type + " | ");
        if (element.getMandatoryParamNames() != null) {
            for (String param : element.getMandatoryParamNames()) {
                out.write(param + "* ");
            }
        }
        if (element.getOptionalParamNames() != null) {
            for (String param : element.getOptionalParamNames()) {
                out.write(param + " ");
            }
        }
        out.write(" | ");
        String descTag = element.getDescriptionTag();
        if (descTag == null) {
            descTag = component + ".api." + type + "." + element.getName();
        }
        try {
            out.write(this.msgs.getString(descTag));
        }
        catch (Exception e) {
            System.out.println("No i18n for: " + descTag);
        }
        out.write(" |\n");
        ++this.methods;
    }

    private void generateWikiComponent(ApiImplementor imp) throws IOException {
        File f = new File(this.dir, this.base + imp.getPrefix() + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + f.getAbsolutePath());
        FileWriter out = new FileWriter(f);
        out.write(this.title);
        out.write("## Component: " + imp.getPrefix() + "\n");
        out.write("| _Name_ | _Type_ | _Parameters_ | _Description_ |\n");
        out.write("|:-------|:-------|:-------------|:--------------|\n");
        for (ApiElement apiElement : imp.getApiViews()) {
            this.generateWikiElement(apiElement, imp.getPrefix(), "view", out);
        }
        for (ApiElement apiElement : imp.getApiActions()) {
            this.generateWikiElement(apiElement, imp.getPrefix(), "action", out);
        }
        for (ApiElement apiElement : imp.getApiOthers()) {
            this.generateWikiElement(apiElement, imp.getPrefix(), "other", out);
        }
        out.write("\n");
        out.write("Starred parameters are mandatory\n\n");
        out.write("Back to [index](" + this.base + "Index)\n\n");
        out.close();
    }

    public static void main(String[] args) throws Exception {
        WikiAPIGenerator wapi = new WikiAPIGenerator();
        wapi.generateWikiFiles(ApiGeneratorUtils.getAllImplementors());
    }
}

