/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;

public class WebUI {
    private API api;

    public WebUI(API api) {
        this.api = api;
    }

    private ApiElement getElement(ApiImplementor impl, String name, API.RequestType reqType) throws ApiException {
        if (API.RequestType.action.equals((Object)reqType) && name != null) {
            List<ApiAction> actionList = impl.getApiActions();
            ApiAction action = null;
            for (ApiAction act : actionList) {
                if (!name.equals(act.getName())) continue;
                action = act;
                break;
            }
            if (action == null) {
                throw new ApiException(ApiException.Type.BAD_ACTION);
            }
            return action;
        }
        if (API.RequestType.other.equals((Object)reqType) && name != null) {
            List<ApiOther> otherList = impl.getApiOthers();
            ApiOther other = null;
            for (ApiOther oth : otherList) {
                if (!name.equals(oth.getName())) continue;
                other = oth;
                break;
            }
            if (other == null) {
                throw new ApiException(ApiException.Type.BAD_OTHER);
            }
            return other;
        }
        if (API.RequestType.view.equals((Object)reqType) && name != null) {
            List<ApiView> viewList = impl.getApiViews();
            ApiView view = null;
            for (ApiView v : viewList) {
                if (!name.equals(v.getName())) continue;
                view = v;
                break;
            }
            if (view == null) {
                throw new ApiException(ApiException.Type.BAD_VIEW);
            }
            return view;
        }
        throw new ApiException(ApiException.Type.BAD_TYPE);
    }

    private void appendElements(StringBuilder sb, String component, String type, List<ApiElement> elementList) {
        Collections.sort(elementList, new Comparator<ApiElement>(){

            @Override
            public int compare(ApiElement ae1, ApiElement ae2) {
                return ae1.getName().compareTo(ae2.getName());
            }
        });
        sb.append("<table>\n");
        for (ApiElement element : elementList) {
            List<String> mandatoryParams = element.getMandatoryParamNames();
            List<String> optionalParams = element.getOptionalParamNames();
            sb.append("<tr>");
            sb.append("<td>");
            sb.append("<a href=\"/");
            sb.append(API.Format.UI.name());
            sb.append('/');
            sb.append(component);
            sb.append('/');
            sb.append(type);
            sb.append('/');
            sb.append(element.getName());
            sb.append("/\">");
            sb.append(element.getName());
            if (mandatoryParams != null || optionalParams != null) {
                sb.append(" (");
                if (mandatoryParams != null) {
                    for (String param : mandatoryParams) {
                        sb.append(param);
                        sb.append("* ");
                    }
                }
                if (optionalParams != null) {
                    for (String param : optionalParams) {
                        sb.append(param);
                        sb.append(" ");
                    }
                }
                sb.append(") ");
            }
            sb.append("</a>");
            sb.append("</td><td>");
            String descTag = element.getDescriptionTag();
            if (descTag == null) {
                descTag = component + ".api." + type + "." + element.getName();
            }
            try {
                sb.append(Constant.messages.getString(descTag));
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append("</td>");
            sb.append("</tr>\n");
        }
        sb.append("</table>\n");
    }

    public String handleRequest(String component, ApiImplementor impl, API.RequestType reqType, String name) throws ApiException {
        StringBuilder sb = new StringBuilder();
        sb.append("<head>\n");
        sb.append("<title>");
        sb.append(Constant.messages.getString("api.html.title"));
        sb.append("</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        if (component != null && reqType != null) {
            sb.append("<script>\n");
            sb.append("function submitScript() {\n");
            if (API.RequestType.other.equals((Object)reqType)) {
                sb.append("var format = '" + API.Format.OTHER.name() + "'\n");
            } else {
                sb.append("var format = document.getElementById('zapapiformat').value\n");
            }
            sb.append("var url = '/' + format + '/" + component + "/" + reqType.name() + "/" + name + "/'\n");
            sb.append("var form=document.getElementById('zapform');\n");
            sb.append("form.action = url;\n");
            sb.append("form.submit();\n");
            sb.append("}\n");
            sb.append("</script>\n");
        }
        sb.append("<h1>");
        sb.append("<a href=\"/");
        sb.append(API.Format.UI.name());
        sb.append("/\">");
        sb.append(Constant.messages.getString("api.html.title"));
        sb.append("</a>");
        sb.append("</h1>\n");
        if (impl != null) {
            sb.append("<h2>");
            sb.append("<a href=\"/");
            sb.append(API.Format.UI.name());
            sb.append("/");
            sb.append(component);
            sb.append("/\">");
            sb.append(Constant.messages.getString("api.html.component"));
            sb.append(component);
            sb.append("</a>");
            sb.append("</h2>\n");
            if (name != null) {
                String key;
                ApiElement element = this.getElement(impl, name, reqType);
                List<String> mandatoryParams = element.getMandatoryParamNames();
                List<String> optionalParams = element.getOptionalParamNames();
                sb.append("<h3>");
                sb.append(Constant.messages.getString("api.html." + reqType.name()));
                sb.append(element.getName());
                sb.append("</h3>\n");
                String descTag = element.getDescriptionTag();
                if (descTag == null) {
                    descTag = component + ".api." + reqType.name() + "." + name;
                }
                try {
                    sb.append(Constant.messages.getString(descTag));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sb.append("<form id=\"zapform\" name=\"zapform\">");
                sb.append("<table>\n");
                if (!API.RequestType.other.equals((Object)reqType)) {
                    sb.append("<tr><td>");
                    sb.append(Constant.messages.getString("api.html.format"));
                    sb.append("</td><td>\n");
                    sb.append("<select id=\"zapapiformat\" name=\"zapapiformat\">\n");
                    sb.append("<option value=\"JSON\">JSON</option>\n");
                    if (this.getOptionsParamApi().isEnableJSONP()) {
                        sb.append("<option value=\"JSONP\">JSONP</option>\n");
                    } else {
                        sb.append("<option value=\"JSONP\" disabled>JSONP</option>\n");
                    }
                    sb.append("<option value=\"HTML\">HTML</option>\n");
                    sb.append("<option value=\"XML\">XML</option>\n");
                    sb.append("</select>\n");
                    sb.append("</td></tr>\n");
                }
                if ((API.RequestType.action.equals((Object)reqType) || API.RequestType.other.equals((Object)reqType)) && (key = this.getOptionsParamApi().getKey()) != null && key.length() > 0) {
                    sb.append("<tr>");
                    sb.append("<td>");
                    sb.append(API.API_KEY_PARAM);
                    sb.append("*</td>");
                    sb.append("<td>");
                    sb.append("<input id=\"");
                    sb.append(API.API_KEY_PARAM);
                    sb.append("\" name=\"");
                    sb.append(API.API_KEY_PARAM);
                    sb.append("\" value=\"");
                    if (this.getOptionsParamApi().isAutofillKey()) {
                        sb.append(key);
                    }
                    sb.append("\"></input>");
                    sb.append("</td>");
                    sb.append("</tr>\n");
                }
                if (mandatoryParams != null) {
                    for (String param : mandatoryParams) {
                        sb.append("<tr>");
                        sb.append("<td>");
                        sb.append(param);
                        sb.append("*</td>");
                        sb.append("<td>");
                        sb.append("<input id=\"");
                        sb.append(param);
                        sb.append("\" name=\"");
                        sb.append(param);
                        sb.append("\"></input>");
                        sb.append("</td>");
                        sb.append("</tr>\n");
                    }
                }
                if (optionalParams != null) {
                    for (String param : optionalParams) {
                        sb.append("<tr>");
                        sb.append("<td>");
                        sb.append(param);
                        sb.append("</td>");
                        sb.append("<td>");
                        sb.append("<input id=\"");
                        sb.append(param);
                        sb.append("\" name=\"");
                        sb.append(param);
                        sb.append("\"></input>");
                        sb.append("</td>");
                        sb.append("</tr>\n");
                    }
                }
                sb.append("<tr>");
                sb.append("<td>");
                sb.append("</td>");
                sb.append("<td>");
                sb.append("<input id=\"button\" value=\"");
                sb.append(element.getName());
                sb.append("\" type=\"button\" onclick=\"submitScript();\">");
                sb.append("</td>");
                sb.append("</tr>\n");
                sb.append("</table>\n");
                sb.append("</form>\n");
            } else {
                List<ApiOther> otherList;
                List<ApiAction> actionList;
                ArrayList<ApiElement> elementList = new ArrayList<ApiElement>();
                List<ApiView> viewList = impl.getApiViews();
                if (viewList != null && viewList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.views"));
                    sb.append("</h3>\n");
                    elementList.addAll(viewList);
                    this.appendElements(sb, component, API.RequestType.view.name(), elementList);
                }
                if ((actionList = impl.getApiActions()) != null && actionList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.actions"));
                    sb.append("</h3>\n");
                    elementList = new ArrayList();
                    elementList.addAll(actionList);
                    this.appendElements(sb, component, API.RequestType.action.name(), elementList);
                }
                if ((otherList = impl.getApiOthers()) != null && otherList.size() > 0) {
                    sb.append("<h3>");
                    sb.append(Constant.messages.getString("api.html.others"));
                    sb.append("</h3>\n");
                    elementList = new ArrayList();
                    elementList.addAll(otherList);
                    this.appendElements(sb, component, API.RequestType.other.name(), elementList);
                }
            }
        } else {
            sb.append("<h3>");
            sb.append(Constant.messages.getString("api.html.components"));
            sb.append("</h3>\n");
            ArrayList<String> components = new ArrayList<String>(this.api.getImplementors().keySet());
            Collections.sort(components);
            sb.append("<table>\n");
            for (String cmp : components) {
                sb.append("<tr>");
                sb.append("<td>");
                sb.append("<a href=\"/");
                sb.append(API.Format.UI.name());
                sb.append('/');
                sb.append(cmp);
                sb.append("/\">");
                sb.append(cmp);
                sb.append("</a>");
                sb.append("</td>");
                sb.append("</tr>\n");
            }
            sb.append("</table>\n");
        }
        sb.append("</body>\n");
        return sb.toString();
    }

    public String handleRequest(URI uri, boolean apiEnabled) {
        StringBuilder sb = new StringBuilder();
        sb.append("<head>\n");
        sb.append("<title>");
        sb.append(Constant.messages.getString("api.html.title"));
        sb.append("</title>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append(Constant.messages.getString("api.home.topmsg"));
        sb.append(Constant.messages.getString("api.home.proxypac"));
        sb.append(Constant.messages.getString("api.home.links.header"));
        if (apiEnabled) {
            sb.append(Constant.messages.getString("api.home.links.api.enabled"));
        } else {
            sb.append(Constant.messages.getString("api.home.links.api.disabled"));
        }
        sb.append(Constant.messages.getString("api.home.links.online"));
        sb.append("</body>\n");
        return sb.toString();
    }

    private OptionsParamApi getOptionsParamApi() {
        return Model.getSingleton().getOptionsParam().getApiParam();
    }
}

