/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import org.apache.commons.configuration.ConfigurationException;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ExtensionAPI;

public class OptionsParamApi
extends AbstractParam {
    public static final String ENABLED = "api.enabled";
    public static final String SECURE_ONLY = "api.secure";
    public static final String POST_ACTIONS = "api.postactions";
    public static final String API_KEY = "api.key";
    private static final String DISABLE_KEY = "api.disablekey";
    private static final String INC_ERROR_DETAILS = "api.incerrordetails";
    private static final String AUTOFILL_KEY = "api.autofillkey";
    private static final String ENABLE_JSONP = "api.enablejsonp";
    private boolean enabled = false;
    private boolean secureOnly = false;
    private boolean disableKey = false;
    private boolean incErrorDetails = false;
    private boolean autofillKey = false;
    private boolean enableJSONP = false;
    private String key = "";

    @Override
    protected void parse() {
        this.enabled = this.getConfig().getBoolean(ENABLED, true);
        this.secureOnly = this.getConfig().getBoolean(SECURE_ONLY, false);
        this.disableKey = this.getConfig().getBoolean(DISABLE_KEY, false);
        this.incErrorDetails = this.getConfig().getBoolean(INC_ERROR_DETAILS, false);
        this.autofillKey = this.getConfig().getBoolean(AUTOFILL_KEY, false);
        this.enableJSONP = this.getConfig().getBoolean(ENABLE_JSONP, false);
        this.key = this.getConfig().getString(API_KEY, "");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.getConfig().setProperty(ENABLED, (Object)enabled);
    }

    public boolean isSecureOnly() {
        return this.secureOnly;
    }

    public void setSecureOnly(boolean secureOnly) {
        this.secureOnly = secureOnly;
        this.getConfig().setProperty(SECURE_ONLY, (Object)secureOnly);
    }

    public boolean isDisableKey() {
        return this.disableKey;
    }

    public void setDisableKey(boolean disableKey) {
        this.disableKey = disableKey;
        this.getConfig().setProperty(DISABLE_KEY, (Object)disableKey);
    }

    public boolean isIncErrorDetails() {
        return this.incErrorDetails;
    }

    public void setIncErrorDetails(boolean incErrorDetails) {
        this.incErrorDetails = incErrorDetails;
        this.getConfig().setProperty(INC_ERROR_DETAILS, (Object)incErrorDetails);
    }

    public boolean isAutofillKey() {
        return this.autofillKey;
    }

    public void setAutofillKey(boolean autofillKey) {
        this.autofillKey = autofillKey;
        this.getConfig().setProperty(AUTOFILL_KEY, (Object)autofillKey);
    }

    public boolean isEnableJSONP() {
        return this.enableJSONP;
    }

    public void setEnableJSONP(boolean enableJSONP) {
        this.enableJSONP = enableJSONP;
        this.getConfig().setProperty(ENABLE_JSONP, (Object)enableJSONP);
    }

    protected String getRealKey() {
        return this.key;
    }

    public String getKey() {
        if (this.isDisableKey()) {
            return "";
        }
        if (this.key == null || this.key.length() == 0) {
            this.key = ExtensionAPI.generateApiKey();
            this.getConfig().setProperty(API_KEY, (Object)this.key);
            try {
                this.getConfig().save();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.getConfig().setProperty(API_KEY, (Object)key);
    }
}

