/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.ZapApiIgnore;

public abstract class ApiImplementor {
    private static final String GET_OPTION_PREFIX = "option";
    private static final String SET_OPTION_PREFIX = "setOption";
    private static final String ADD_OPTION_PREFIX = "addOption";
    private static final String REMOVE_OPTION_PREFIX = "removeOption";
    private static final Comparator<Method> METHOD_NAME_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method method, Method otherMethod) {
            if (method == null) {
                if (otherMethod == null) {
                    return 0;
                }
                return -1;
            }
            if (otherMethod == null) {
                return 1;
            }
            return method.getName().compareTo(otherMethod.getName());
        }
    };
    private List<ApiAction> apiActions = new ArrayList<ApiAction>();
    private List<ApiView> apiViews = new ArrayList<ApiView>();
    private List<ApiOther> apiOthers = new ArrayList<ApiOther>();
    private List<String> apiShortcuts = new ArrayList<String>();
    private AbstractParam param = null;

    public List<ApiView> getApiViews() {
        return this.apiViews;
    }

    public List<ApiAction> getApiActions() {
        return this.apiActions;
    }

    public List<ApiOther> getApiOthers() {
        return this.apiOthers;
    }

    public void addApiView(ApiView view) {
        this.apiViews.add(view);
    }

    public void addApiOthers(ApiOther other) {
        this.apiOthers.add(other);
    }

    public void addApiAction(ApiAction action) {
        this.apiActions.add(action);
    }

    public void addApiShortcut(String shortcut) {
        this.apiShortcuts.add(shortcut);
    }

    public void addApiOptions(AbstractParam param) {
        this.param = param;
        Method[] methods = param.getClass().getDeclaredMethods();
        Arrays.sort(methods, METHOD_NAME_COMPARATOR);
        ArrayList<String> addedActions = new ArrayList<String>();
        for (Method method : methods) {
            if (ApiImplementor.isIgnored(method)) continue;
            if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                this.addApiView(new ApiView(GET_OPTION_PREFIX + method.getName().substring(3)));
            }
            if (method.getName().startsWith("is") && method.getParameterTypes().length == 0) {
                this.addApiView(new ApiView(GET_OPTION_PREFIX + method.getName().substring(2)));
            }
            if (method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String.class)) {
                this.addApiAction(new ApiAction(SET_OPTION_PREFIX + method.getName().substring(3), new String[]{"String"}));
                addedActions.add(method.getName());
            }
            if (method.getName().startsWith("add") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(String.class)) {
                this.addApiAction(new ApiAction(ADD_OPTION_PREFIX + method.getName().substring(3), new String[]{"String"}));
                addedActions.add(method.getName());
            }
            if (!method.getName().startsWith("remove") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            this.addApiAction(new ApiAction(REMOVE_OPTION_PREFIX + method.getName().substring(6), new String[]{"String"}));
            addedActions.add(method.getName());
        }
        for (Method method : methods) {
            if (ApiImplementor.isIgnored(method) || !method.getName().startsWith("set") || method.getParameterTypes().length != 1 || addedActions.contains(method.getName())) continue;
            if (method.getParameterTypes()[0].equals(Integer.class) || method.getParameterTypes()[0].equals(Integer.TYPE)) {
                this.addApiAction(new ApiAction(SET_OPTION_PREFIX + method.getName().substring(3), new String[]{"Integer"}));
                addedActions.add(method.getName());
                continue;
            }
            if (!method.getParameterTypes()[0].equals(Boolean.class) && !method.getParameterTypes()[0].equals(Boolean.TYPE)) continue;
            this.addApiAction(new ApiAction(SET_OPTION_PREFIX + method.getName().substring(3), new String[]{"Boolean"}));
            addedActions.add(method.getName());
        }
    }

    private static boolean isIgnored(Method method) {
        return method.getAnnotation(ZapApiIgnore.class) != null || !Modifier.isPublic(method.getModifiers());
    }

    public ApiResponse handleApiOptionView(String name, JSONObject params) throws ApiException {
        if (this.param == null) {
            return null;
        }
        if (name.startsWith(GET_OPTION_PREFIX)) {
            Method[] methods;
            name = name.substring(GET_OPTION_PREFIX.length());
            for (Method method : methods = this.param.getClass().getDeclaredMethods()) {
                if (ApiImplementor.isIgnored(method) || !method.getName().equals("get" + name) && !method.getName().equals("is" + name) || method.getParameterTypes().length != 0) continue;
                try {
                    return new ApiResponseElement(name, method.invoke((Object)this.param, new Object[0]).toString());
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
            }
        }
        return null;
    }

    public ApiResponse handleApiOptionAction(String name, JSONObject params) throws ApiException {
        if (this.param == null) {
            return null;
        }
        boolean isApiOption = false;
        if (name.startsWith(SET_OPTION_PREFIX)) {
            name = "set" + name.substring(SET_OPTION_PREFIX.length());
            isApiOption = true;
        } else if (name.startsWith(ADD_OPTION_PREFIX)) {
            name = "add" + name.substring(ADD_OPTION_PREFIX.length());
            isApiOption = true;
        } else if (name.startsWith(REMOVE_OPTION_PREFIX)) {
            name = "remove" + name.substring(REMOVE_OPTION_PREFIX.length());
            isApiOption = true;
        }
        if (isApiOption) {
            try {
                Method[] methods;
                for (Method method : methods = this.param.getClass().getDeclaredMethods()) {
                    if (ApiImplementor.isIgnored(method) || !method.getName().equals(name) || method.getParameterTypes().length != 1) continue;
                    Object val = null;
                    if (method.getParameterTypes()[0].equals(String.class)) {
                        val = params.getString("String");
                    } else {
                        if (method.getParameterTypes()[0].equals(Integer.class) || method.getParameterTypes()[0].equals(Integer.TYPE)) {
                            try {
                                val = params.getInt("Integer");
                            }
                            catch (JSONException e) {
                                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Integer");
                            }
                        }
                        if (method.getParameterTypes()[0].equals(Boolean.class) || method.getParameterTypes()[0].equals(Boolean.TYPE)) {
                            try {
                                val = params.getBoolean("Boolean");
                            }
                            catch (JSONException e) {
                                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "Boolean");
                            }
                        }
                    }
                    if (val == null) continue;
                    method.invoke((Object)this.param, val);
                    return ApiResponseElement.OK;
                }
            }
            catch (ApiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
            }
        }
        return null;
    }

    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        throw new ApiException(ApiException.Type.BAD_VIEW, name);
    }

    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        throw new ApiException(ApiException.Type.BAD_ACTION, name);
    }

    public HttpMessage handleApiOther(HttpMessage msg, String name, JSONObject params) throws ApiException {
        throw new ApiException(ApiException.Type.BAD_OTHER, name);
    }

    public String handleCallBack(HttpMessage msg) throws ApiException {
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, msg.getRequestHeader().getURI().toString());
    }

    public HttpMessage handleShortcut(HttpMessage msg) throws ApiException {
        throw new ApiException(ApiException.Type.URL_NOT_FOUND, msg.getRequestHeader().getURI().toString());
    }

    public abstract String getPrefix();

    public ApiAction getApiAction(String name) {
        for (ApiAction action : this.apiActions) {
            if (!action.getName().equals(name)) continue;
            return action;
        }
        return null;
    }

    public ApiView getApiView(String name) {
        for (ApiView view : this.apiViews) {
            if (!view.getName().equals(name)) continue;
            return view;
        }
        return null;
    }

    public ApiOther getApiOther(String name) {
        for (ApiOther other : this.apiOthers) {
            if (!other.getName().equals(name)) continue;
            return other;
        }
        return null;
    }

    protected List<String> getApiShortcuts() {
        return this.apiShortcuts;
    }

    protected int getParam(JSONObject params, String name, int defaultValue) {
        try {
            return params.getInt(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String getParam(JSONObject params, String name, String defaultValue) {
        try {
            return params.getString(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected boolean getParam(JSONObject params, String name, boolean defaultValue) {
        try {
            return params.getBoolean(name);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void addCustomHeaders(String name, API.RequestType type, HttpMessage msg) {
    }
}

