/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.history.HistoryFilter;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfAPI;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfDetectScanner;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParam;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.OptionsAntiCsrfPanel;
import org.zaproxy.zap.extension.anticsrf.PopupMenuGenerateForm;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;

public class ExtensionAntiCSRF
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionAntiCSRF";
    public static final String TAG = "AntiCSRF";
    private Map<String, AntiCsrfToken> valueToToken = new HashMap<String, AntiCsrfToken>();
    private OptionsAntiCsrfPanel optionsAntiCsrfPanel = null;
    private PopupMenuGenerateForm popupMenuGenerateForm = null;
    private Encoder encoder = new Encoder();
    private static Logger log = Logger.getLogger(ExtensionAntiCSRF.class);
    private AntiCsrfDetectScanner antiCsrfDetectScanner;
    private HistoryReferenceFactory historyReferenceFactory;

    public ExtensionAntiCSRF() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(50);
    }

    @Override
    public void init() {
        this.antiCsrfDetectScanner = new AntiCsrfDetectScanner(this);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        ExtensionPassiveScan extensionPassiveScan;
        super.hook(extensionHook);
        final ExtensionHistory extensionHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        this.historyReferenceFactory = extensionHistory != null ? new HistoryReferenceFactory(){

            @Override
            public HistoryReference createHistoryReference(int id) {
                return extensionHistory.getHistoryReference(id);
            }
        } : new HistoryReferenceFactory(){

            @Override
            public HistoryReference createHistoryReference(int id) throws HttpMalformedHeaderException, DatabaseException {
                return new HistoryReference(id);
            }
        };
        AntiCsrfToken.setHistoryReferenceFactory(this.historyReferenceFactory);
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsAntiCsrfPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuGenerateForm());
        }
        if ((extensionPassiveScan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan")) != null) {
            extensionPassiveScan.addPassiveScanner(this.antiCsrfDetectScanner);
        }
        AntiCsrfAPI api = new AntiCsrfAPI(this);
        api.addApiOptions(this.getParam());
        API.getInstance().registerApiImplementor(api);
    }

    @Override
    public void unload() {
        ExtensionPassiveScan extensionPassiveScan = (ExtensionPassiveScan)Control.getSingleton().getExtensionLoader().getExtension("ExtensionPassiveScan");
        if (extensionPassiveScan != null) {
            extensionPassiveScan.removePassiveScanner(this.antiCsrfDetectScanner);
        }
        super.unload();
    }

    private PopupMenuGenerateForm getPopupMenuGenerateForm() {
        if (this.popupMenuGenerateForm == null) {
            this.popupMenuGenerateForm = new PopupMenuGenerateForm(Constant.messages.getString("anticsrf.genForm.popup"));
        }
        return this.popupMenuGenerateForm;
    }

    private OptionsAntiCsrfPanel getOptionsAntiCsrfPanel() {
        if (this.optionsAntiCsrfPanel == null) {
            this.optionsAntiCsrfPanel = new OptionsAntiCsrfPanel();
        }
        return this.optionsAntiCsrfPanel;
    }

    protected AntiCsrfParam getParam() {
        return Model.getSingleton().getOptionsParam().getAntiCsrfParam();
    }

    public List<String> getAntiCsrfTokenNames() {
        return this.getParam().getTokensNames();
    }

    public void addAntiCsrfTokenName(String token) {
        this.getParam().addToken(token);
    }

    public void removeAntiCsrfTokenName(String token) {
        this.getParam().removeToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAntiCsrfToken(AntiCsrfToken token) {
        log.debug((Object)("registerAntiCsrfToken " + token.getMsg().getRequestHeader().getURI().toString() + " " + token.getValue()));
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            try {
                HistoryReference hRef = token.getMsg().getHistoryRef();
                if (hRef == null) {
                    hRef = new HistoryReference(this.getModel().getSession(), 0, token.getMsg());
                    token.getMsg().setHistoryRef(null);
                }
                token.setHistoryReferenceId(hRef.getHistoryId());
                this.valueToToken.put(this.encoder.getURLEncode(token.getValue()), token);
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                log.error((Object)"Failed to persist the message: ", (Throwable)e);
            }
        }
    }

    public boolean requestHasToken(HttpMessage msg) {
        return this.requestHasToken(msg.getRequestBody().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestHasToken(String reqBody) {
        Set<String> values;
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            values = Collections.unmodifiableSet(new HashSet<String>(this.valueToToken.keySet()));
        }
        for (String token : values) {
            if (reqBody.indexOf(token) < 0) continue;
            return true;
        }
        return false;
    }

    public List<AntiCsrfToken> getTokens(HttpMessage msg) {
        return this.getTokens(msg.getRequestBody().toString(), msg.getRequestHeader().getURI().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AntiCsrfToken> getTokens(String reqBody, String targetUrl) {
        Set<String> values;
        ArrayList<AntiCsrfToken> tokens = new ArrayList<AntiCsrfToken>();
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            values = Collections.unmodifiableSet(new HashSet<String>(this.valueToToken.keySet()));
        }
        for (String value : values) {
            if (reqBody.indexOf(value) < 0) continue;
            AntiCsrfToken token = this.valueToToken.get(value).clone();
            token.setTargetURL(targetUrl);
            tokens.add(token);
        }
        return tokens;
    }

    public String getTokenValue(HttpMessage tokenMsg, String tokenName) {
        String response = tokenMsg.getResponseHeader().toString() + tokenMsg.getResponseBody().toString();
        Source source = new Source((CharSequence)response);
        List formElements = source.getAllElements("form");
        if (formElements != null && formElements.size() > 0) {
            for (Element formElement : formElements) {
                List inputElements = formElement.getAllElements("input");
                if (inputElements == null || inputElements.size() <= 0) continue;
                for (Element inputElement : inputElements) {
                    String id = inputElement.getAttributeValue("ID");
                    if (id != null && id.equalsIgnoreCase(tokenName)) {
                        return inputElement.getAttributeValue("VALUE");
                    }
                    String name = inputElement.getAttributeValue("NAME");
                    if (name == null || !name.equalsIgnoreCase(tokenName)) continue;
                    return inputElement.getAttributeValue("VALUE");
                }
            }
        }
        return null;
    }

    public List<AntiCsrfToken> getTokensFromResponse(HttpMessage msg, Source source) {
        ArrayList<AntiCsrfToken> list = new ArrayList<AntiCsrfToken>();
        List formElements = source.getAllElements("form");
        if (formElements != null && formElements.size() > 0) {
            log.debug((Object)("Found " + formElements.size() + " forms"));
            int formIndex = 0;
            for (Element formElement : formElements) {
                List inputElements = formElement.getAllElements("input");
                if (inputElements != null && inputElements.size() > 0) {
                    log.debug((Object)("Found " + inputElements.size() + " inputs"));
                    block1: for (Element inputElement : inputElements) {
                        String name;
                        String value = inputElement.getAttributeValue("VALUE");
                        if (value == null) continue;
                        String attId = inputElement.getAttributeValue("ID");
                        boolean found = false;
                        if (attId != null) {
                            for (String tokenName : this.getAntiCsrfTokenNames()) {
                                if (!tokenName.equalsIgnoreCase(attId)) continue;
                                list.add(new AntiCsrfToken(msg, attId, value, formIndex));
                                found = true;
                                break;
                            }
                        }
                        if (found || (name = inputElement.getAttributeValue("NAME")) == null) continue;
                        for (String tokenName : this.getAntiCsrfTokenNames()) {
                            if (!tokenName.equalsIgnoreCase(name)) continue;
                            list.add(new AntiCsrfToken(msg, name, value, formIndex));
                            continue block1;
                        }
                    }
                }
                ++formIndex;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionChanged(Session session) {
        if (session == null) {
            return;
        }
        Map<String, AntiCsrfToken> map = this.valueToToken;
        synchronized (map) {
            this.valueToToken.clear();
        }
        try {
            List<Integer> list = this.getModel().getDb().getTableHistory().getHistoryIdsOfHistType(session.getSessionId(), 1, 15);
            HistoryFilter filter = new HistoryFilter();
            filter.setTags(Arrays.asList(TAG));
            AntiCsrfDetectScanner antiCsrfDetectScanner = new AntiCsrfDetectScanner(this);
            for (Integer i : list) {
                HistoryReference hRef = this.historyReferenceFactory.createHistoryReference(i);
                if (!filter.matches(hRef)) continue;
                HttpMessage msg = hRef.getHttpMessage();
                String response = msg.getResponseHeader().toString() + msg.getResponseBody().toString();
                Source src = new Source((CharSequence)response);
                if (!msg.isResponseFromTargetHost()) continue;
                antiCsrfDetectScanner.scanHttpResponseReceive(msg, hRef.getHistoryId(), src);
            }
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isAntiCsrfToken(String name) {
        if (name == null) {
            return false;
        }
        return this.getParam().getTokensNames().contains(name.toLowerCase());
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("anticsrf.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public String generateForm(int hrefId) throws Exception {
        ExtensionHistory extHist = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        if (extHist != null) {
            HistoryReference hr = extHist.getHistoryReference(hrefId);
            if (hr == null) {
                return null;
            }
            HttpMessage msg = hr.getHttpMessage();
            StringBuilder sb = new StringBuilder(300);
            sb.append("<html>\n");
            sb.append("<body>\n");
            sb.append("<h3>");
            sb.append(msg.getRequestHeader().getURI());
            sb.append("</h3>");
            sb.append("<form id=\"f1\" method=\"POST\" action=\"" + hr.getURI() + "\">\n");
            sb.append("<table>\n");
            TreeSet<HtmlParameter> params = msg.getFormParams();
            msg = null;
            for (HtmlParameter htmlParam : params) {
                String name = URLDecoder.decode(htmlParam.getName(), "UTF-8");
                String value = URLDecoder.decode(htmlParam.getValue(), "UTF-8");
                sb.append("<tr><td>\n");
                sb.append(name);
                sb.append("<td>");
                sb.append("<input name=\"");
                sb.append(name);
                sb.append("\" value=\"");
                sb.append(value);
                sb.append("\" size=\"100\">");
                sb.append("</tr>\n");
            }
            sb.append("</table>\n");
            sb.append("</form>\n");
            sb.append("<button onclick=\"document.getElementById('f1').submit()\">Submit</button>\n");
            sb.append("</body>\n");
            sb.append("</html>\n");
            return sb.toString();
        }
        return null;
    }

    static interface HistoryReferenceFactory {
        public HistoryReference createHistoryReference(int var1) throws DatabaseException, HttpMalformedHeaderException;
    }
}

