/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.alert.ExtensionAlert;

public class PopupMenuAlertDelete
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionAlert extension = null;

    public PopupMenuAlertDelete() {
        this.initialize();
    }

    public PopupMenuAlertDelete(String label) {
        super(label);
    }

    private void initialize() {
        this.setText(Constant.messages.getString("scanner.delete.popup"));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath[] paths = PopupMenuAlertDelete.this.extension.getAlertPanel().getTreeAlert().getSelectionPaths();
                if (paths != null) {
                    if (View.getSingleton().showConfirmDialog(Constant.messages.getString("scanner.delete.confirm")) != 0) {
                        return;
                    }
                    for (TreePath path : paths) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                        PopupMenuAlertDelete.this.deleteNode(node);
                    }
                }
            }
        });
    }

    private void deleteNode(DefaultMutableTreeNode node) {
        Object obj;
        while (node.getChildCount() > 0) {
            this.deleteNode((DefaultMutableTreeNode)node.getChildAt(0));
        }
        if (node.getUserObject() != null && (obj = node.getUserObject()) instanceof Alert) {
            this.extension.deleteAlert((Alert)obj);
        }
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker.getName() != null && invoker.getName().equals("treeAlert")) {
            try {
                DefaultMutableTreeNode node;
                JTree tree = (JTree)invoker;
                if (tree.getLastSelectedPathComponent() != null && !(node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()).isRoot()) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    void setExtension(ExtensionAlert extension) {
        this.extension = extension;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

