/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.zaproxy.zap.extension.alert.AlertParam;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsAlertPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = -7541236934312940852L;
    private static final String NAME = Constant.messages.getString("alert.optionspanel.name");
    private ZapNumberSpinner maxInstances = null;
    private JCheckBox mergeRelatedIssues = null;

    public OptionsAlertPanel() {
        this.setName(NAME);
        this.setLayout(new FlowLayout(3, 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(2, 2, 2, 2));
        panel.add((Component)this.getMergeRelatedIssues(), LayoutHelper.getGBC(0, 0, 1, 1.0, new Insets(2, 2, 2, 2)));
        JLabel maxInstancesLabel = new JLabel(Constant.messages.getString("alert.optionspanel.label.maxinstances"));
        maxInstancesLabel.setLabelFor(this.getMaxInstances());
        panel.add((Component)maxInstancesLabel, LayoutHelper.getGBC(0, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
        panel.add((Component)this.getMaxInstances(), LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(2, 2, 2, 2)));
        this.add(panel);
    }

    private JCheckBox getMergeRelatedIssues() {
        if (this.mergeRelatedIssues == null) {
            this.mergeRelatedIssues = new JCheckBox();
            this.mergeRelatedIssues.setText(Constant.messages.getString("alert.optionspanel.label.mergerelated"));
            this.mergeRelatedIssues.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    OptionsAlertPanel.this.getMaxInstances().setEditable(OptionsAlertPanel.this.mergeRelatedIssues.isSelected());
                }
            });
        }
        return this.mergeRelatedIssues;
    }

    private ZapNumberSpinner getMaxInstances() {
        if (this.maxInstances == null) {
            this.maxInstances = new ZapNumberSpinner();
        }
        return this.maxInstances;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        AlertParam param = options.getParamSet(AlertParam.class);
        this.getMaxInstances().setValue((Object)param.getMaximumInstances());
        this.getMergeRelatedIssues().setSelected(param.isMergeRelatedIssues());
        this.getMaxInstances().setEditable(param.isMergeRelatedIssues());
    }

    @Override
    public void validateParam(Object obj) throws Exception {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        AlertParam param = options.getParamSet(AlertParam.class);
        param.setMaximumInstances(this.getMaxInstances().getValue());
        param.setMergeRelatedIssues(this.getMergeRelatedIssues().isSelected());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.alert";
    }
}

