/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.zaproxy.zap.control.AddOnClassnames;

public class AddOnClassLoader
extends URLClassLoader {
    private final ParentClassLoader parent;
    private final List<AddOnClassLoader> childClassLoaders;
    private List<AddOnClassLoader> dependencies;
    private AddOnClassnames addOnClassnames;

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent) {
        this(addOnFileUrl, parent, Collections.emptyList(), AddOnClassnames.ALL_ALLOWED);
    }

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent, AddOnClassnames addOnClassnames) {
        this(addOnFileUrl, parent, Collections.emptyList(), addOnClassnames);
    }

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent, List<AddOnClassLoader> dependencies) {
        this(addOnFileUrl, parent, dependencies, AddOnClassnames.ALL_ALLOWED);
    }

    public AddOnClassLoader(URL addOnFileUrl, ClassLoader parent, List<AddOnClassLoader> dependencies, AddOnClassnames addOnClassnames) {
        super(new URL[]{addOnFileUrl}, (ClassLoader)null);
        if (addOnFileUrl == null) {
            throw new IllegalArgumentException("Parameter addOnFileUrl must not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Parameter parent must not be null.");
        }
        if (dependencies == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        this.parent = new ParentClassLoader(parent);
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(dependencies);
        this.childClassLoaders = new ArrayList<AddOnClassLoader>(2);
        this.addOnClassnames = addOnClassnames;
    }

    public AddOnClassLoader(AddOnClassLoader parent, List<AddOnClassLoader> dependencies) {
        super(parent.getURLs(), (ClassLoader)null);
        if (dependencies == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        parent.childClassLoaders.add(this);
        this.parent = new ParentClassLoader(parent);
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(dependencies);
        this.childClassLoaders = Collections.emptyList();
        this.addOnClassnames = AddOnClassnames.ALL_ALLOWED;
    }

    public AddOnClassLoader(AddOnClassLoader parent, List<AddOnClassLoader> dependencies, AddOnClassnames addOnClassnames) {
        super(parent.getURLs(), (ClassLoader)null);
        if (dependencies == null) {
            throw new IllegalArgumentException("Parameter dependencies must not be null.");
        }
        if (addOnClassnames == null) {
            throw new IllegalArgumentException("Parameter addOnClassnames must not be null.");
        }
        parent.childClassLoaders.add(this);
        this.parent = new ParentClassLoader(parent);
        this.dependencies = dependencies.isEmpty() ? Collections.emptyList() : new ArrayList<AddOnClassLoader>(dependencies);
        this.childClassLoaders = Collections.emptyList();
        this.addOnClassnames = addOnClassnames;
    }

    public void removeChildClassLoader(AddOnClassLoader child) {
        this.childClassLoaders.remove(child);
    }

    @Override
    public void close() throws IOException {
        for (AddOnClassLoader childClassLoader : this.childClassLoaders) {
            childClassLoader.close();
        }
        super.close();
    }

    public void clearDependencies() {
        this.dependencies = Collections.emptyList();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.addOnClassnames.isAllowed(name)) {
            try {
                return this.findClassInAddOn(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            return this.parent.loadClass(name, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<?> clazz = this.findClassInDependencies(name);
            if (clazz == null) {
                throw new ClassNotFoundException();
            }
            return clazz;
        }
    }

    private Class<?> findClassInAddOn(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    private Class<?> findClassInDependencies(String name) {
        if (this.dependencies.isEmpty()) {
            return null;
        }
        for (AddOnClassLoader addOnClassLoader : this.dependencies) {
            try {
                return addOnClassLoader.loadClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @Override
    public URL findResource(String name) {
        URL url = this.findResourceInAddOn(name);
        if (url == null) {
            url = this.parent.getResource(name);
        }
        if (url == null) {
            url = this.findResourceInDependencies(name);
        }
        return url;
    }

    public URL findResourceInAddOn(String name) {
        return super.findResource(name);
    }

    private URL findResourceInDependencies(String name) {
        if (this.dependencies.isEmpty()) {
            return null;
        }
        for (AddOnClassLoader addOnClassLoader : this.dependencies) {
            URL url = addOnClassLoader.findResourceInAddOn(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private static class ParentClassLoader
    extends ClassLoader {
        public ParentClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }
    }
}

