/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import net.sf.json.JSONObject;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.EncodingUtils;
import org.zaproxy.zap.view.DynamicFieldsPanel;

public class GenericAuthenticationCredentials
implements AuthenticationCredentials {
    private static final String API_NAME = "GenericAuthenticationCredentials";
    private String[] paramNames;
    private Map<String, String> paramValues;
    private static final String ACTION_SET_CREDENTIALS = "scriptBasedAuthenticationCredentials";
    private static final String PARAM_CONFIG_PARAMS = "authenticationCredentialsParams";

    public GenericAuthenticationCredentials(String[] paramNames) {
        this.paramNames = paramNames;
        this.paramValues = new HashMap<String, String>(paramNames.length);
    }

    public String getParam(String paramName) {
        return this.paramValues.get(paramName);
    }

    public String setParam(String paramName, String paramValue) {
        return this.paramValues.put(paramName, paramValue);
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public String encode(String parentFieldSeparator) {
        return EncodingUtils.mapToString(this.paramValues);
    }

    @Override
    public void decode(String encodedCredentials) {
        this.paramValues = EncodingUtils.stringToMap(encodedCredentials);
        this.paramNames = this.paramValues.keySet().toArray(new String[this.paramValues.size()]);
    }

    @Override
    public ApiResponse getApiResponseRepresentation() {
        HashMap<String, String> values = new HashMap<String, String>(this.paramValues);
        values.put("type", API_NAME);
        return new ApiResponseSet("credentials", values);
    }

    public static ApiDynamicActionImplementor getSetCredentialsForUserApiAction(final AuthenticationMethodType methodType) {
        return new ApiDynamicActionImplementor(ACTION_SET_CREDENTIALS, null, new String[]{PARAM_CONFIG_PARAMS}){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                int userId = ApiUtils.getIntParam(params, "userId");
                if (!methodType.isTypeForMethod(context.getAuthenticationMethod())) {
                    throw new ApiException(ApiException.Type.BAD_TYPE, "User's credentials should match authentication method type of the context: " + context.getAuthenticationMethod().getType().getName());
                }
                ExtensionUserManagement extensionUserManagement = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
                User user = extensionUserManagement.getContextUserAuthManager(context.getIndex()).getUserById(userId);
                if (user == null) {
                    throw new ApiException(ApiException.Type.USER_NOT_FOUND, "userId");
                }
                GenericAuthenticationCredentials credentials = (GenericAuthenticationCredentials)context.getAuthenticationMethod().createAuthenticationCredentials();
                for (String paramName : credentials.paramNames) {
                    credentials.setParam(paramName, ApiUtils.getNonEmptyStringParam(params, paramName));
                }
                user.setAuthenticationCredentials(credentials);
            }
        };
    }

    protected static class GenericAuthenticationCredentialsOptionsPanel
    extends AbstractCredentialsOptionsPanel<GenericAuthenticationCredentials> {
        private static final long serialVersionUID = -6486907666459197059L;
        private DynamicFieldsPanel fieldsPanel;

        public GenericAuthenticationCredentialsOptionsPanel(GenericAuthenticationCredentials credentials) {
            super(credentials);
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new BorderLayout());
            this.fieldsPanel = new DynamicFieldsPanel(((GenericAuthenticationCredentials)this.credentials).paramNames);
            this.fieldsPanel.bindFieldValues(((GenericAuthenticationCredentials)this.credentials).paramValues);
            this.add((Component)this.fieldsPanel, "Center");
        }

        @Override
        public boolean validateFields() {
            try {
                this.fieldsPanel.validateFields();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), Constant.messages.getString("authentication.method.fb.dialog.error.title"), 2);
                return false;
            }
            return true;
        }

        @Override
        public void saveCredentials() {
            ((GenericAuthenticationCredentials)this.credentials).paramValues = new HashMap<String, String>(this.fieldsPanel.getFieldValues());
        }
    }
}

