/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractParamContainerPanel;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;

public class AbstractParamDialog
extends AbstractDialog {
    private static final long serialVersionUID = -5223178126156052670L;
    private int exitResult = 2;
    private JPanel jContentPane = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private AbstractParamContainerPanel jSplitPane;
    private JLabel footer = null;
    private String rootName = null;

    public AbstractParamDialog() {
        this.initialize();
    }

    public AbstractParamDialog(Window parent, boolean modal, String title, String rootName) throws HeadlessException {
        super(parent, modal);
        this.rootName = rootName;
        this.initialize();
        this.setTitle(title);
    }

    private void initialize() {
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(500, 375);
        }
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            this.footer = new JLabel();
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.gridy = 1;
            gridBagConstraints12.ipadx = 0;
            gridBagConstraints12.ipady = 0;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.ipadx = 0;
            gridBagConstraints13.ipady = 0;
            gridBagConstraints13.fill = 0;
            gridBagConstraints13.anchor = 13;
            gridBagConstraints13.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints14.gridx = 2;
            gridBagConstraints14.gridy = 1;
            gridBagConstraints14.ipadx = 0;
            gridBagConstraints14.ipady = 0;
            gridBagConstraints14.anchor = 13;
            gridBagConstraints14.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.anchor = 18;
            gridBagConstraints1.gridwidth = 3;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            this.jContentPane.add((Component)this.getJSplitPane(), gridBagConstraints1);
            this.jContentPane.add((Component)this.footer, gridBagConstraints12);
            this.jContentPane.add((Component)this.getBtnCancel(), gridBagConstraints13);
            this.jContentPane.add((Component)this.getBtnOK(), gridBagConstraints14);
        }
        return this.jContentPane;
    }

    public void setFooter(String str) {
        this.footer.setText(str);
    }

    private JButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new JButton();
            this.btnOK.setName("btnOK");
            this.btnOK.setText(Constant.messages.getString("all.button.ok"));
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        AbstractParamDialog.this.validateParam();
                        AbstractParamDialog.this.saveParam();
                        AbstractParamDialog.this.exitResult = 0;
                        AbstractParamDialog.this.setVisible(false);
                    }
                    catch (Exception ex) {
                        View.getSingleton().showWarningDialog(ex.getMessage());
                    }
                }
            });
        }
        return this.btnOK;
    }

    protected JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setName("btnCancel");
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractParamDialog.this.exitResult = 2;
                    AbstractParamDialog.this.setVisible(false);
                }
            });
        }
        return this.btnCancel;
    }

    private AbstractParamContainerPanel getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new AbstractParamContainerPanel();
            this.jSplitPane.setVisible(true);
            if (this.rootName != null) {
                this.jSplitPane.getRootNode().setUserObject(this.rootName);
            }
        }
        return this.jSplitPane;
    }

    public void addParamPanel(String[] parentParams, String name, AbstractParamPanel panel, boolean sort) {
        this.getJSplitPane().addParamPanel(parentParams, name, panel, sort);
    }

    public void addParamPanel(String[] parentParams, AbstractParamPanel panel, boolean sort) {
        this.addParamPanel(parentParams, panel.getName(), panel, sort);
    }

    public void removeParamPanel(AbstractParamPanel panel) {
        this.getJSplitPane().removeParamPanel(panel);
    }

    public void showParamPanel(String parent, String child) {
        this.getJSplitPane().showParamPanel(parent, child);
    }

    public void showParamPanel(String name) {
        this.getJSplitPane().showParamPanel(name);
    }

    public void showParamPanel(AbstractParamPanel panel, String name) {
        this.getJSplitPane().showParamPanel(panel, name);
    }

    public void initParam(Object obj) {
        this.getJSplitPane().initParam(obj);
    }

    public void validateParam() throws Exception {
        this.getJSplitPane().validateParam();
    }

    public void saveParam() throws Exception {
        this.getJSplitPane().saveParam();
    }

    protected void expandRoot() {
        this.getJSplitPane().expandRoot();
    }

    public int showDialog(boolean showRoot) {
        return this.showDialog(showRoot, null);
    }

    public int showDialog(boolean showRoot, String panel) {
        this.getJSplitPane().showDialog(showRoot, panel);
        this.setVisible(true);
        return this.exitResult;
    }

    protected Collection<AbstractParamPanel> getPanels() {
        return this.getJSplitPane().getPanels();
    }

    public void printTree() {
        this.getJSplitPane().printTree();
    }

    public void renamePanel(AbstractParamPanel panel, String newPanelName) {
        this.getJSplitPane().renamePanel(panel, newPanelName);
    }
}

