/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.WorkbenchPanel;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.TimeStampUtils;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.view.LayoutHelper;

public class OptionsViewPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final String TIME_STAMP_FORMAT_COMBOBOX_TOOL_TIP = Constant.messages.getString("options.display.timestamp.format.combobox.tooltip");
    private static final String TIME_STAMP_FORMAT_DATETIME = Constant.messages.getString("timestamp.format.datetime");
    private static final String TIME_STAMP_FORMAT_ISO8601 = Constant.messages.getString("timestamp.format.iso8601");
    private static final String TIME_STAMP_FORMAT_TIMEONLY = Constant.messages.getString("timestamp.format.timeonly");
    private JPanel panelMisc = null;
    private JCheckBox chkShowTabNames = null;
    private JCheckBox chkProcessImages = null;
    private JCheckBox chkShowMainToolbar = null;
    private JCheckBox chkAdvancedView = null;
    private JCheckBox chkAskOnExit = null;
    private JCheckBox chkWmUiHandling = null;
    private JCheckBox chkOutputTabTimeStamping = null;
    private JCheckBox chkShowSplashScreen = null;
    private JCheckBox scaleImages = null;
    private JCheckBox showLocalConnectRequestsCheckbox;
    private JComboBox<String> brkPanelViewSelect = null;
    private JComboBox<String> displaySelect = null;
    private JComboBox<ResponsePanelPositionUI> responsePanelPositionComboBox;
    private JComboBox<String> timeStampsFormatSelect = null;
    private JComboBox<String> fontName = null;
    private ZapNumberSpinner largeRequestSize = null;
    private ZapNumberSpinner largeResponseSize = null;
    private ZapNumberSpinner fontSize = null;
    private JLabel brkPanelViewLabel = null;
    private JLabel advancedViewLabel = null;
    private JLabel wmUiHandlingLabel = null;
    private JLabel askOnExitLabel = null;
    private JLabel displayLabel = null;
    private JLabel showMainToolbarLabel = null;
    private JLabel processImagesLabel = null;
    private JLabel showTabNamesLabel = null;
    private JLabel outputTabTimeStampLabel = null;
    private JLabel outputTabTimeStampExampleLabel = null;
    private JLabel showSplashScreenLabel = null;
    private JLabel largeRequestLabel = null;
    private JLabel largeResponseLabel = null;
    private JLabel fontExampleLabel = null;

    public OptionsViewPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(Constant.messages.getString("view.options.title"));
        this.add((Component)this.getPanelMisc(), this.getPanelMisc().getName());
    }

    private JPanel getPanelMisc() {
        if (this.panelMisc == null) {
            this.panelMisc = new JPanel();
            this.panelMisc.setLayout(new GridBagLayout());
            if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
                this.panelMisc.setSize(114, 132);
            }
            this.panelMisc.setName(Constant.messages.getString("view.options.misc.title"));
            this.displayLabel = new JLabel(Constant.messages.getString("view.options.label.display"));
            this.brkPanelViewLabel = new JLabel(Constant.messages.getString("view.options.label.brkPanelView"));
            this.advancedViewLabel = new JLabel(Constant.messages.getString("view.options.label.advancedview"));
            this.wmUiHandlingLabel = new JLabel(Constant.messages.getString("view.options.label.wmuihandler"));
            this.askOnExitLabel = new JLabel(Constant.messages.getString("view.options.label.askonexit"));
            this.showMainToolbarLabel = new JLabel(Constant.messages.getString("view.options.label.showMainToolbar"));
            this.processImagesLabel = new JLabel(Constant.messages.getString("view.options.label.processImages"));
            this.showTabNamesLabel = new JLabel(Constant.messages.getString("view.options.label.showTabNames"));
            this.outputTabTimeStampLabel = new JLabel(Constant.messages.getString("options.display.timestamp.format.outputtabtimestamps.label"));
            this.largeRequestLabel = new JLabel(Constant.messages.getString("view.options.label.largeRequestSize"));
            this.largeResponseLabel = new JLabel(Constant.messages.getString("view.options.label.largeResponseSize"));
            this.outputTabTimeStampExampleLabel = new JLabel(TimeStampUtils.currentDefaultFormattedTimeStamp());
            this.showSplashScreenLabel = new JLabel(Constant.messages.getString("view.options.label.showSplashScreen"));
            int row = 0;
            this.displayLabel.setLabelFor(this.getDisplaySelect());
            this.panelMisc.add((Component)this.displayLabel, LayoutHelper.getGBC(0, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getDisplaySelect(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel responsePanelPositionLabel = new JLabel(Constant.messages.getString("view.options.label.responsepanelpos"));
            this.panelMisc.add((Component)responsePanelPositionLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getResponsePanelPositionComboBox(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.brkPanelViewLabel.setLabelFor(this.getBrkPanelViewSelect());
            this.panelMisc.add((Component)this.brkPanelViewLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getBrkPanelViewSelect(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.largeRequestLabel.setLabelFor(this.getLargeRequestSize());
            this.panelMisc.add((Component)this.largeRequestLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getLargeRequestSize(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.largeResponseLabel.setLabelFor(this.getLargeResponseSize());
            this.panelMisc.add((Component)this.largeResponseLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getLargeResponseSize(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.advancedViewLabel.setLabelFor(this.getChkAdvancedView());
            this.panelMisc.add((Component)this.advancedViewLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkAdvancedView(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.wmUiHandlingLabel.setLabelFor(this.getChkWmUiHandling());
            this.panelMisc.add((Component)this.wmUiHandlingLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkWmUiHandling(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.askOnExitLabel.setLabelFor(this.getChkAskOnExit());
            this.panelMisc.add((Component)this.askOnExitLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkAskOnExit(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.showMainToolbarLabel.setLabelFor(this.getChkShowMainToolbar());
            this.panelMisc.add((Component)this.showMainToolbarLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkShowMainToolbar(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.processImagesLabel.setLabelFor(this.getChkProcessImages());
            this.panelMisc.add((Component)this.processImagesLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkProcessImages(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            Insets insets = new Insets(2, 2, 2, 2);
            String labelText = Constant.messages.getString("view.options.label.showlocalconnectrequests");
            JLabel showConnectRequestLabel = new JLabel(labelText);
            showConnectRequestLabel.setLabelFor(this.getShowLocalConnectRequestsCheckbox());
            this.panelMisc.add((Component)showConnectRequestLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, insets));
            this.panelMisc.add((Component)this.getShowLocalConnectRequestsCheckbox(), LayoutHelper.getGBC(1, row, 1, 1.0, insets));
            this.showTabNamesLabel.setLabelFor(this.getShowTabNames());
            this.panelMisc.add((Component)this.showTabNamesLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getShowTabNames(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.showSplashScreenLabel.setLabelFor(this.getShowSplashScreen());
            this.panelMisc.add((Component)this.showSplashScreenLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getShowSplashScreen(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.outputTabTimeStampLabel.setLabelFor(this.getChkOutputTabTimeStamps());
            this.panelMisc.add((Component)this.outputTabTimeStampLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getChkOutputTabTimeStamps(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.outputTabTimeStampExampleLabel.setLabelFor(this.getTimeStampsFormatSelect());
            this.panelMisc.add(this.getTimeStampsFormatSelect(), LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.outputTabTimeStampExampleLabel, LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel fontNameLabel = new JLabel(Constant.messages.getString("view.options.label.fontName"));
            fontNameLabel.setLabelFor(this.getFontName());
            this.panelMisc.add((Component)fontNameLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add(this.getFontName(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel fontSizeLabel = new JLabel(Constant.messages.getString("view.options.label.fontSize"));
            fontSizeLabel.setLabelFor(this.getFontSize());
            this.panelMisc.add((Component)fontSizeLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getFontSize(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel fontExampleLabel = new JLabel(Constant.messages.getString("view.options.label.fontExample"));
            fontExampleLabel.setLabelFor(this.getFontExampleLabel());
            this.panelMisc.add((Component)fontExampleLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getFontExampleLabel(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            JLabel scaleImagesLabel = new JLabel(Constant.messages.getString("view.options.label.scaleImages"));
            fontExampleLabel.setLabelFor(this.getScaleImages());
            this.panelMisc.add((Component)scaleImagesLabel, LayoutHelper.getGBC(0, ++row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)this.getScaleImages(), LayoutHelper.getGBC(1, row, 1, 1.0, new Insets(2, 2, 2, 2)));
            this.panelMisc.add((Component)new JLabel(""), LayoutHelper.getGBC(0, ++row, 1, 1.0, 1.0));
        }
        return this.panelMisc;
    }

    private JCheckBox getShowTabNames() {
        if (this.chkShowTabNames == null) {
            this.chkShowTabNames = new JCheckBox();
            this.chkShowTabNames.setVerticalAlignment(1);
            this.chkShowTabNames.setVerticalTextPosition(1);
        }
        return this.chkShowTabNames;
    }

    private JCheckBox getShowSplashScreen() {
        if (this.chkShowSplashScreen == null) {
            this.chkShowSplashScreen = new JCheckBox();
            this.chkShowSplashScreen.setVerticalAlignment(1);
            this.chkShowSplashScreen.setVerticalTextPosition(1);
        }
        return this.chkShowSplashScreen;
    }

    private JCheckBox getChkProcessImages() {
        if (this.chkProcessImages == null) {
            this.chkProcessImages = new JCheckBox();
            this.chkProcessImages.setVerticalAlignment(1);
            this.chkProcessImages.setVerticalTextPosition(1);
        }
        return this.chkProcessImages;
    }

    private JCheckBox getChkShowMainToolbar() {
        if (this.chkShowMainToolbar == null) {
            this.chkShowMainToolbar = new JCheckBox();
            this.chkShowMainToolbar.setVerticalAlignment(1);
            this.chkShowMainToolbar.setVerticalTextPosition(1);
        }
        return this.chkShowMainToolbar;
    }

    private JCheckBox getChkWmUiHandling() {
        if (this.chkWmUiHandling == null) {
            this.chkWmUiHandling = new JCheckBox();
            this.chkWmUiHandling.setVerticalAlignment(1);
            this.chkWmUiHandling.setVerticalTextPosition(1);
        }
        return this.chkWmUiHandling;
    }

    private JCheckBox getChkAskOnExit() {
        if (this.chkAskOnExit == null) {
            this.chkAskOnExit = new JCheckBox();
            this.chkAskOnExit.setVerticalAlignment(1);
            this.chkAskOnExit.setVerticalTextPosition(1);
        }
        return this.chkAskOnExit;
    }

    private JComboBox<String> getDisplaySelect() {
        if (this.displaySelect == null) {
            this.displaySelect = new JComboBox();
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.left"));
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.bottom"));
            this.displaySelect.addItem(Constant.messages.getString("view.options.label.display.full"));
        }
        return this.displaySelect;
    }

    private JComboBox<ResponsePanelPositionUI> getResponsePanelPositionComboBox() {
        if (this.responsePanelPositionComboBox == null) {
            this.responsePanelPositionComboBox = new JComboBox();
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.tabs"), WorkbenchPanel.ResponsePanelPosition.TABS_SIDE_BY_SIDE));
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.sideBySide"), WorkbenchPanel.ResponsePanelPosition.PANELS_SIDE_BY_SIDE));
            this.responsePanelPositionComboBox.addItem(new ResponsePanelPositionUI(Constant.messages.getString("view.options.label.responsepanelpos.above"), WorkbenchPanel.ResponsePanelPosition.PANEL_ABOVE));
        }
        return this.responsePanelPositionComboBox;
    }

    private JComboBox<String> getBrkPanelViewSelect() {
        if (this.brkPanelViewSelect == null) {
            this.brkPanelViewSelect = new JComboBox();
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.toolbaronly"));
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.breakonly"));
            this.brkPanelViewSelect.addItem(Constant.messages.getString("view.options.label.brkPanelView.both"));
        }
        return this.brkPanelViewSelect;
    }

    private JCheckBox getChkAdvancedView() {
        if (this.chkAdvancedView == null) {
            this.chkAdvancedView = new JCheckBox();
            this.chkAdvancedView.setVerticalAlignment(1);
            this.chkAdvancedView.setVerticalTextPosition(1);
        }
        return this.chkAdvancedView;
    }

    private JCheckBox getChkOutputTabTimeStamps() {
        if (this.chkOutputTabTimeStamping == null) {
            this.chkOutputTabTimeStamping = new JCheckBox();
            this.chkOutputTabTimeStamping.setVerticalAlignment(1);
            this.chkOutputTabTimeStamping.setVerticalTextPosition(1);
            this.chkOutputTabTimeStamping.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OptionsViewPanel.this.timeStampsFormatSelect.setEnabled(e.getStateChange() == 1);
                }
            });
        }
        return this.chkOutputTabTimeStamping;
    }

    private JComboBox<String> getTimeStampsFormatSelect() {
        if (this.timeStampsFormatSelect == null) {
            String[] timeStampFormatStrings = new String[]{TIME_STAMP_FORMAT_DATETIME, TIME_STAMP_FORMAT_ISO8601, TIME_STAMP_FORMAT_TIMEONLY};
            this.timeStampsFormatSelect = new JComboBox<String>(timeStampFormatStrings);
            this.timeStampsFormatSelect.setToolTipText(TIME_STAMP_FORMAT_COMBOBOX_TOOL_TIP);
            this.timeStampsFormatSelect.setSelectedItem(this.getTimeStampsFormatSelect().getSelectedItem());
            this.timeStampsFormatSelect.setEditable(true);
            if (this.chkOutputTabTimeStamping.isSelected()) {
                this.timeStampsFormatSelect.setEnabled(true);
            } else {
                this.timeStampsFormatSelect.setEnabled(false);
            }
            this.timeStampsFormatSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selectedDateFormat = (String)OptionsViewPanel.this.getTimeStampsFormatSelect().getSelectedItem();
                    OptionsViewPanel.this.outputTabTimeStampExampleLabel.setText(TimeStampUtils.currentFormattedTimeStamp(selectedDateFormat));
                }
            });
        }
        return this.timeStampsFormatSelect;
    }

    private JCheckBox getShowLocalConnectRequestsCheckbox() {
        if (this.showLocalConnectRequestsCheckbox == null) {
            this.showLocalConnectRequestsCheckbox = new JCheckBox();
        }
        return this.showLocalConnectRequestsCheckbox;
    }

    private ZapNumberSpinner getLargeRequestSize() {
        if (this.largeRequestSize == null) {
            this.largeRequestSize = new ZapNumberSpinner(-1, 100000, Integer.MAX_VALUE);
        }
        return this.largeRequestSize;
    }

    private ZapNumberSpinner getLargeResponseSize() {
        if (this.largeResponseSize == null) {
            this.largeResponseSize = new ZapNumberSpinner(-1, 100000, Integer.MAX_VALUE);
        }
        return this.largeResponseSize;
    }

    private ZapNumberSpinner getFontSize() {
        if (this.fontSize == null) {
            this.fontSize = new ZapNumberSpinner(-1, 8, 100);
            if (!FontUtils.canChangeSize()) {
                this.fontSize.setEnabled(false);
            }
            this.fontSize.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    OptionsViewPanel.this.setExampleFont();
                }
            });
        }
        return this.fontSize;
    }

    private void setExampleFont() {
        String name = this.getFontName().getSelectedItem() == null ? "" : (String)this.getFontName().getSelectedItem();
        Font font = FontUtils.getFont(name);
        int size = this.getFontSize().getValue();
        if (size == -1) {
            size = FontUtils.getSystemDefaultFont().getSize();
        }
        this.getFontExampleLabel().setFont(font.deriveFont((float)size));
    }

    private JComboBox<String> getFontName() {
        if (this.fontName == null) {
            this.fontName = new JComboBox();
            this.fontName.setRenderer(new JComboBoxFontRenderer());
            String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            this.fontName.addItem(" ");
            for (String font : fonts) {
                this.fontName.addItem(font);
            }
            if (!FontUtils.canChangeSize()) {
                this.fontName.setEnabled(false);
            }
            this.fontName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsViewPanel.this.setExampleFont();
                }
            });
        }
        return this.fontName;
    }

    private JLabel getFontExampleLabel() {
        if (this.fontExampleLabel == null) {
            this.fontExampleLabel = new JLabel(Constant.messages.getString("view.options.label.exampleText"));
            this.fontExampleLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
        return this.fontExampleLabel;
    }

    private JCheckBox getScaleImages() {
        if (this.scaleImages == null) {
            this.scaleImages = new JCheckBox();
            if (!FontUtils.canChangeSize()) {
                this.scaleImages.setEnabled(false);
            }
        }
        return this.scaleImages;
    }

    @Override
    public void initParam(Object obj) {
        OptionsParam options = (OptionsParam)obj;
        this.getShowTabNames().setSelected(options.getViewParam().getShowTabNames());
        this.getShowSplashScreen().setSelected(options.getViewParam().isShowSplashScreen());
        this.getChkProcessImages().setSelected(options.getViewParam().getProcessImages() > 0);
        this.displaySelect.setSelectedIndex(options.getViewParam().getDisplayOption());
        this.selectResponstPanelPosition(options.getViewParam().getResponsePanelPosition());
        this.brkPanelViewSelect.setSelectedIndex(options.getViewParam().getBrkPanelViewOption());
        this.getChkShowMainToolbar().setSelected(options.getViewParam().isShowMainToolbar());
        this.chkAdvancedView.setSelected(options.getViewParam().getAdvancedViewOption() > 0);
        this.chkAskOnExit.setSelected(options.getViewParam().getAskOnExitOption() > 0);
        this.chkWmUiHandling.setSelected(options.getViewParam().getWmUiHandlingOption() > 0);
        this.getChkOutputTabTimeStamps().setSelected(options.getViewParam().isOutputTabTimeStampingEnabled());
        this.timeStampsFormatSelect.setSelectedItem(options.getViewParam().getOutputTabTimeStampsFormat());
        this.getShowLocalConnectRequestsCheckbox().setSelected(options.getViewParam().isShowLocalConnectRequests());
        this.largeRequestSize.setValue(options.getViewParam().getLargeRequestSize());
        this.largeResponseSize.setValue(options.getViewParam().getLargeResponseSize());
        this.getFontSize().setValue(options.getViewParam().getFontSize());
        this.getFontName().setSelectedItem(options.getViewParam().getFontName());
        this.getScaleImages().setSelected(options.getViewParam().isScaleImages());
    }

    private void selectResponstPanelPosition(String positionName) {
        for (int i = 0; i < this.getResponsePanelPositionComboBox().getItemCount(); ++i) {
            ResponsePanelPositionUI item = this.getResponsePanelPositionComboBox().getItemAt(i);
            if (!item.getPosition().name().equals(positionName)) continue;
            this.getResponsePanelPositionComboBox().setSelectedIndex(i);
            break;
        }
        if (this.getResponsePanelPositionComboBox().getSelectedIndex() == -1) {
            this.getResponsePanelPositionComboBox().setSelectedIndex(0);
        }
    }

    @Override
    public void validateParam(Object obj) {
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        OptionsParam options = (OptionsParam)obj;
        options.getViewParam().setShowTabNames(this.getShowTabNames().isSelected());
        options.getViewParam().setShowSplashScreen(this.getShowSplashScreen().isSelected());
        options.getViewParam().setProcessImages(this.getChkProcessImages().isSelected() ? 1 : 0);
        options.getViewParam().setDisplayOption(this.displaySelect.getSelectedIndex());
        ResponsePanelPositionUI selectedItem = (ResponsePanelPositionUI)this.getResponsePanelPositionComboBox().getSelectedItem();
        options.getViewParam().setResponsePanelPosition(selectedItem.getPosition().name());
        options.getViewParam().setBrkPanelViewOption(this.brkPanelViewSelect.getSelectedIndex());
        options.getViewParam().setShowMainToolbar(this.getChkShowMainToolbar().isSelected());
        options.getViewParam().setAdvancedViewOption(this.getChkAdvancedView().isSelected() ? 1 : 0);
        options.getViewParam().setAskOnExitOption(this.getChkAskOnExit().isSelected() ? 1 : 0);
        options.getViewParam().setWmUiHandlingOption(this.getChkWmUiHandling().isSelected() ? 1 : 0);
        options.getViewParam().setOutputTabTimeStampingEnabled(this.getChkOutputTabTimeStamps().isSelected());
        options.getViewParam().setOutputTabTimeStampsFormat((String)this.getTimeStampsFormatSelect().getSelectedItem());
        options.getViewParam().setShowLocalConnectRequests(this.getShowLocalConnectRequestsCheckbox().isSelected());
        options.getViewParam().setLargeRequestSize(this.getLargeRequestSize().getValue());
        options.getViewParam().setLargeResponseSize(this.getLargeResponseSize().getValue());
        options.getViewParam().setFontSize(this.getFontSize().getValue());
        options.getViewParam().setFontName((String)this.getFontName().getSelectedItem());
        options.getViewParam().setScaleImages(this.getScaleImages().isSelected());
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.view";
    }

    private static class ResponsePanelPositionUI {
        private final String name;
        private final WorkbenchPanel.ResponsePanelPosition position;

        public ResponsePanelPositionUI(String name, WorkbenchPanel.ResponsePanelPosition position) {
            this.name = name;
            this.position = position;
        }

        public WorkbenchPanel.ResponsePanelPosition getPosition() {
            return this.position;
        }

        public String toString() {
            return this.name;
        }
    }

    private class JComboBoxFontRenderer
    extends BasicComboBoxRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private JComboBoxFontRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Font font = FontUtils.getFont((String)value);
            if (font != null) {
                renderer.setFont(FontUtils.getFont((String)value));
            } else {
                renderer.setFont(FontUtils.getFont(FontUtils.Size.standard));
            }
            return renderer;
        }
    }
}

