/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuExportMessage
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(PopupMenuExportMessage.class);
    private static final String CRLF = "\r\n";
    private ExtensionHistory extension = null;

    public PopupMenuExportMessage() {
        this.initialize();
    }

    public PopupMenuExportMessage(String label) {
        super(label);
    }

    private void initialize() {
        this.setText(Constant.messages.getString("history.export.messages.popup"));
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                List<HistoryReference> hrefs = PopupMenuExportMessage.this.extension.getSelectedHistoryReferences();
                if (hrefs.size() == 0) {
                    PopupMenuExportMessage.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.messages.select.warning"));
                    return;
                }
                File file = PopupMenuExportMessage.this.getOutputFile();
                if (file == null) {
                    return;
                }
                boolean isAppend = true;
                if (file.exists()) {
                    int rc = PopupMenuExportMessage.this.extension.getView().showYesNoCancelDialog(Constant.messages.getString("file.overwrite.warning"));
                    if (rc == 2) {
                        return;
                    }
                    if (rc == 0) {
                        isAppend = false;
                    }
                }
                BufferedWriter fw = null;
                try {
                    fw = new BufferedWriter(new FileWriter(file, isAppend));
                    for (HistoryReference href : hrefs) {
                        PopupMenuExportMessage.this.exportHistory(href, fw);
                    }
                }
                catch (Exception e1) {
                    PopupMenuExportMessage.this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath() + ".");
                    log.warn((Object)e1.getMessage(), (Throwable)e1);
                }
                finally {
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (Exception e2) {
                        log.warn((Object)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
        });
    }

    void setExtension(ExtensionHistory extension) {
        this.extension = extension;
    }

    private void exportHistory(HistoryReference ref, Writer writer) {
        if (ref == null) {
            return;
        }
        String s = null;
        try {
            HttpMessage msg = ref.getHttpMessage();
            writer.write("==== " + ref.getHistoryId() + " ==========" + CRLF);
            s = msg.getRequestHeader().toString();
            writer.write(s);
            s = msg.getRequestBody().toString();
            writer.write(s);
            if (!s.endsWith(CRLF)) {
                writer.write(CRLF);
            }
            if (!msg.getResponseHeader().isEmpty()) {
                s = msg.getResponseHeader().toString();
                writer.write(s);
                s = msg.getResponseBody().toString();
                writer.write(s);
                if (!s.endsWith(CRLF)) {
                    writer.write(CRLF);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private File getOutputFile() {
        JFileChooser chooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.ascii");
            }
        });
        File file = null;
        int rc = chooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (rc == 0) {
            file = chooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(chooser.getCurrentDirectory());
            String fileName = file.getAbsolutePath();
            if (!fileName.endsWith(".txt")) {
                fileName = fileName + ".txt";
                file = new File(fileName);
            }
            return file;
        }
        return file;
    }
}

