/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JList;
import javax.swing.JTree;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteNode;

@Deprecated
public class PopupMenuEmbeddedBrowser
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    private ExtensionHistory extension = null;
    private Component lastInvoker = null;
    private BrowserLauncher launcher = null;
    private boolean supported = true;

    public PopupMenuEmbeddedBrowser() {
        this.initialize();
    }

    public PopupMenuEmbeddedBrowser(String label) {
        super(label);
        this.initialize();
    }

    private void initialize() {
        this.setText(Constant.messages.getString("history.browser.popup"));
        this.setActionCommand("");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryReference ref = null;
                if (PopupMenuEmbeddedBrowser.this.lastInvoker == null) {
                    return;
                }
                if (PopupMenuEmbeddedBrowser.this.lastInvoker.getName().equalsIgnoreCase("ListLog")) {
                    ref = PopupMenuEmbeddedBrowser.this.extension.getSelectedHistoryReference();
                    PopupMenuEmbeddedBrowser.this.showBrowser(ref);
                } else if (PopupMenuEmbeddedBrowser.this.lastInvoker.getName().equals("treeSite")) {
                    JTree tree = (JTree)PopupMenuEmbeddedBrowser.this.lastInvoker;
                    SiteNode node = (SiteNode)tree.getLastSelectedPathComponent();
                    ref = node.getHistoryReference();
                    PopupMenuEmbeddedBrowser.this.showBrowser(ref);
                }
            }
        });
    }

    private BrowserLauncher getBrowserLauncher() {
        if (!this.supported) {
            return null;
        }
        if (this.launcher == null) {
            try {
                this.launcher = new BrowserLauncher();
            }
            catch (BrowserLaunchingInitializingException e) {
                this.supported = false;
            }
            catch (UnsupportedOperatingSystemException e) {
                this.supported = false;
            }
        }
        return this.launcher;
    }

    private void showBrowser(HistoryReference ref) {
        if (!this.supported) {
            return;
        }
        try {
            this.getBrowserLauncher().openURLinBrowser(ref.getURI().toString());
        }
        catch (Exception e) {
            this.extension.getView().showWarningDialog(Constant.messages.getString("history.browser.warning"));
        }
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        this.lastInvoker = null;
        if (!this.supported) {
            return false;
        }
        if (invoker.getName() == null) {
            return false;
        }
        if (invoker.getName().equalsIgnoreCase("ListLog")) {
            JList list = (JList)invoker;
            if (list.getSelectedIndex() >= 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.lastInvoker = invoker;
            return true;
        }
        if (invoker.getName().equals("treeSite")) {
            JTree tree = (JTree)invoker;
            this.lastInvoker = tree;
            SiteNode node = (SiteNode)tree.getLastSelectedPathComponent();
            this.setEnabled(node != null && node.getHistoryReference() != null);
            return true;
        }
        return false;
    }

    void setExtension(ExtensionHistory extension) {
        this.extension = extension;
    }
}

