/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;

public class FilterLogRequestResponse
extends FilterAdaptor {
    private static final String logFile = "filter/message.txt";
    private static final String delim = "====================================";
    private static final String CRLF = "\r\n";
    private File outFile = new File("filter/message.txt");
    private BufferedWriter writer = null;
    private long lastWriteTime = System.currentTimeMillis();
    private int counter = 1;
    private Logger logger = Logger.getLogger(FilterLogRequestResponse.class);

    @Override
    public int getId() {
        return 40;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.logreqresp.name") + logFile;
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
        if (!httpMessage.getRequestHeader().isText() || httpMessage.getRequestHeader().isImage() || httpMessage.getResponseHeader().isImage()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(httpMessage.getRequestHeader().toString());
        sb.append(httpMessage.getRequestBody().toString()).append(CRLF);
        if (!httpMessage.getResponseHeader().isEmpty()) {
            sb.append(httpMessage.getResponseHeader().toString());
            sb.append(httpMessage.getResponseBody().toString()).append(CRLF);
        }
        this.writeLogFile(sb.toString());
    }

    private synchronized void writeLogFile(String line) {
        try {
            if (this.getWriter() != null) {
                this.getWriter().write("===== " + this.counter + " " + delim + CRLF);
                this.getWriter().write(line + CRLF);
                ++this.counter;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized void timer() {
        if (this.writer != null && System.currentTimeMillis() > this.lastWriteTime + 5000L) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.outFile, true));
        }
        return this.writer;
    }
}

