/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.Hashtable;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterLogGetQuery;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class FilterLogPostQuery
extends FilterLogGetQuery {
    private static final Logger logger = Logger.getLogger(FilterLogPostQuery.class);

    @Override
    public int getId() {
        return 30;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.logposts.name") + this.getLogFileName();
    }

    @Override
    protected String getLogFileName() {
        return "filter/post.xls";
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
        HttpRequestHeader reqHeader = httpMessage.getRequestHeader();
        if (reqHeader != null && reqHeader.isText() && !reqHeader.isImage() && reqHeader.getMethod().equalsIgnoreCase("POST")) {
            try {
                URI uri = reqHeader.getURI();
                URI newURI = (URI)uri.clone();
                String query = httpMessage.getRequestBody().toString();
                if (query != null) {
                    newURI.setQuery(null);
                    String firstline = newURI.toString();
                    Hashtable<String, String> param = this.parseParameter(query);
                    this.writeLogFile(firstline, param);
                } else {
                    String firstline = uri.toString();
                    this.writeLogFile(firstline, null);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

