/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class FilterLogGetQuery
extends FilterAdaptor {
    private static final String delim = "\t";
    private static final String CRLF = "\r\n";
    private File outFile;
    private Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Matcher matcher2;
    private BufferedWriter writer = null;
    private long lastWriteTime = System.currentTimeMillis();
    private static final Logger logger = Logger.getLogger(FilterLogGetQuery.class);

    @Override
    public int getId() {
        return 20;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.loggets.name") + this.getLogFileName();
    }

    @Override
    public void init(Model model) {
        this.outFile = new File(this.getLogFileName());
    }

    protected String getLogFileName() {
        return "filter/get.xls";
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
        HttpRequestHeader reqHeader = httpMessage.getRequestHeader();
        if (reqHeader != null && reqHeader.isText() && !reqHeader.isImage() && reqHeader.getMethod().equalsIgnoreCase("GET")) {
            try {
                URI uri = reqHeader.getURI();
                URI newURI = (URI)uri.clone();
                String query = newURI.getQuery();
                if (query != null) {
                    newURI.setQuery(null);
                    String firstline = newURI.toString();
                    Hashtable<String, String> param = this.parseParameter(query);
                    this.writeLogFile(firstline, param);
                } else {
                    String firstline = uri.toString();
                    this.writeLogFile(firstline, null);
                }
            }
            catch (Exception aa) {
                logger.error((Object)aa.getMessage(), (Throwable)aa);
            }
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
    }

    protected synchronized void writeLogFile(String line, Hashtable<String, String> param) {
        try {
            if (this.getWriter() != null) {
                this.getWriter().write(line + CRLF);
            }
            if (param != null) {
                Enumeration<String> v = param.keys();
                while (v.hasMoreElements()) {
                    String name = v.nextElement();
                    String value = param.get(name);
                    this.getWriter().write(delim + name + delim + value + CRLF);
                }
            }
            this.lastWriteTime = System.currentTimeMillis();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected Hashtable<String, String> parseParameter(String param) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            this.matcher2 = this.pSeparator.matcher(param);
            while (this.matcher2.find()) {
                table.put(this.matcher2.group(1), this.matcher2.group(2));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return table;
    }

    @Override
    public synchronized void timer() {
        if (this.writer != null && System.currentTimeMillis() > this.lastWriteTime + 5000L) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private synchronized BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.outFile, true));
        }
        return this.writer;
    }
}

