/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeaderField;
import org.parosproxy.paros.network.HttpMessage;

public class VariantHeader
implements Variant {
    @Deprecated
    public static final String[] injectableHeaders = new String[]{"User-Agent", "Referer", "Host"};
    private static final String[] injectablesTempArray = new String[]{"Content-Length".toLowerCase(Locale.ROOT), "Pragma".toLowerCase(Locale.ROOT), "Cache-Control".toLowerCase(Locale.ROOT), "Cookie".toLowerCase(Locale.ROOT), "Authorization".toLowerCase(Locale.ROOT), "Proxy-Authorization".toLowerCase(Locale.ROOT), "Connection".toLowerCase(Locale.ROOT), "Proxy-Connection".toLowerCase(Locale.ROOT), "If-Modified-Since".toLowerCase(Locale.ROOT), "If-None-Match".toLowerCase(Locale.ROOT), "X-Csrf-Token".toLowerCase(Locale.ROOT), "X-CsrfToken".toLowerCase(Locale.ROOT), "X-Xsrf-Token".toLowerCase(Locale.ROOT), "X-ZAP-Scan-ID".toLowerCase(Locale.ROOT), "X-ZAP-RequestID".toLowerCase(Locale.ROOT), "X-Security-Proxy".toLowerCase(Locale.ROOT)};
    private static final HashSet<String> NON_INJECTABLE_HEADERS = new HashSet<String>(Arrays.asList(injectablesTempArray));
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private static final Logger log = Logger.getLogger(VariantHeader.class);
    private static ScannerParam scannerOptions;

    @Override
    public void setMessage(HttpMessage msg) {
        if (!this.isValidMessageToScan(msg)) {
            return;
        }
        List<HttpHeaderField> httpHeaders = msg.getRequestHeader().getHeaders();
        int headerPos = 0;
        for (HttpHeaderField header : httpHeaders) {
            if (NON_INJECTABLE_HEADERS.contains(header.getName().toLowerCase(Locale.ROOT))) continue;
            this.params.add(new NameValuePair(8, header.getName(), header.getValue(), headerPos++));
        }
    }

    private boolean isValidMessageToScan(HttpMessage msg) {
        if (VariantHeader.getScannerOptions().isScanHeadersAllRequests()) {
            return true;
        }
        String query = null;
        try {
            query = msg.getRequestHeader().getURI().getQuery();
        }
        catch (URIException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return query != null && !query.isEmpty() || msg.getRequestBody().length() != 0;
    }

    private static ScannerParam getScannerOptions() {
        if (scannerOptions == null) {
            VariantHeader.getScannerOptionsSync();
        }
        return scannerOptions;
    }

    private static synchronized void getScannerOptionsSync() {
        if (scannerOptions == null) {
            scannerOptions = Model.getSingleton().getOptionsParam().getParamSet(ScannerParam.class);
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage msg, NameValuePair originalPair, String name, String value) {
        return this.setParameter(msg, originalPair, name, value, true);
    }

    private String setParameter(HttpMessage msg, NameValuePair originalPair, String name, String value, boolean escaped) {
        msg.getRequestHeader().setHeader(originalPair.getName(), value);
        return name + ":" + value;
    }
}

