/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.httpclient.HttpException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Kb;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;

public abstract class AbstractPlugin
implements Plugin,
Comparable<Object> {
    private static final String[] NO_DEPENDENCIES = new String[0];
    protected static final int PATTERN_PARAM = 10;
    protected static final String CRLF = "\r\n";
    private HostProcess parent = null;
    private HttpMessage msg = null;
    private boolean enabled = true;
    private Logger log = Logger.getLogger(this.getClass());
    private Configuration config = null;
    private int delayInMs;
    private ExtensionAntiCSRF extAntiCSRF = null;
    private Encoder encoder = new Encoder();
    private Plugin.AlertThreshold defaultAttackThreshold = Plugin.AlertThreshold.MEDIUM;
    private static final Plugin.AlertThreshold[] alertThresholdsSupported = new Plugin.AlertThreshold[]{Plugin.AlertThreshold.MEDIUM};
    private Plugin.AttackStrength defaultAttackStrength = Plugin.AttackStrength.MEDIUM;
    private static final Plugin.AttackStrength[] attackStrengthsSupported = new Plugin.AttackStrength[]{Plugin.AttackStrength.MEDIUM};
    private TechSet techSet = null;
    private Date started = null;
    private Date finished = null;
    private AddOn.Status status = AddOn.Status.unknown;

    @Override
    public abstract int getId();

    @Override
    public abstract String getName();

    @Override
    public String getCodeName() {
        String result = this.getClass().getName();
        int pos = this.getClass().getName().lastIndexOf(".");
        if (pos > -1) {
            result = result.substring(pos + 1);
        }
        return result;
    }

    @Override
    public String[] getDependency() {
        return NO_DEPENDENCIES;
    }

    @Override
    public abstract String getDescription();

    @Override
    public abstract int getCategory();

    @Override
    public abstract String getSolution();

    @Override
    public abstract String getReference();

    @Override
    public void init(HttpMessage msg, HostProcess parent) {
        this.msg = msg.cloneAll();
        this.parent = parent;
        if (this.parent.getScannerParam().isInjectPluginIdInHeader()) {
            this.msg.getRequestHeader().setHeader("X-ZAP-Scan-ID", Integer.toString(this.getId()));
        }
        this.init();
    }

    public void init() {
    }

    protected HttpMessage getNewMsg() {
        return this.msg.cloneRequest();
    }

    protected HttpMessage getBaseMsg() {
        return this.msg;
    }

    protected void sendAndReceive(HttpMessage msg) throws HttpException, IOException {
        this.sendAndReceive(msg, true);
    }

    protected void sendAndReceive(HttpMessage msg, boolean isFollowRedirect) throws HttpException, IOException {
        this.sendAndReceive(msg, isFollowRedirect, true);
    }

    protected void sendAndReceive(HttpMessage msg, boolean isFollowRedirect, boolean handleAntiCSRF) throws HttpException, IOException {
        if (this.parent.handleAntiCsrfTokens() && handleAntiCSRF) {
            if (this.extAntiCSRF == null) {
                this.extAntiCSRF = (ExtensionAntiCSRF)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAntiCSRF");
            }
            if (this.extAntiCSRF != null) {
                List<AntiCsrfToken> tokens = this.extAntiCSRF.getTokens(msg);
                AntiCsrfToken antiCsrfToken = null;
                if (tokens.size() > 0) {
                    antiCsrfToken = tokens.get(0);
                }
                if (antiCsrfToken != null) {
                    this.regenerateAntiCsrfToken(msg, antiCsrfToken);
                }
            }
        }
        msg.getRequestHeader().setHeader("If-Modified-Since", null);
        msg.getRequestHeader().setHeader("If-None-Match", null);
        msg.getRequestHeader().setContentLength(msg.getRequestBody().length());
        if (this.getDelayInMs() > 0) {
            try {
                Thread.sleep(this.getDelayInMs());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.parent.performScannerHookBeforeScan(msg, this);
        this.parent.getHttpSender().sendAndReceive(msg, isFollowRedirect);
        this.parent.notifyNewMessage(this, msg);
        this.parent.performScannerHookAfterScan(msg, this);
    }

    private void regenerateAntiCsrfToken(HttpMessage msg, AntiCsrfToken antiCsrfToken) {
        if (antiCsrfToken == null) {
            return;
        }
        String tokenValue = null;
        try {
            HttpMessage tokenMsg = antiCsrfToken.getMsg().cloneAll();
            this.sendAndReceive(tokenMsg, true, false);
            tokenValue = this.extAntiCSRF.getTokenValue(tokenMsg, antiCsrfToken.getName());
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (tokenValue != null) {
            this.log.debug((Object)("regenerateAntiCsrfToken replacing " + antiCsrfToken.getValue() + " with " + this.encoder.getURLEncode(tokenValue)));
            String replaced = msg.getRequestBody().toString();
            replaced = replaced.replace(this.encoder.getURLEncode(antiCsrfToken.getValue()), this.encoder.getURLEncode(tokenValue));
            msg.setRequestBody(replaced);
            this.extAntiCSRF.registerAntiCsrfToken(new AntiCsrfToken(msg, antiCsrfToken.getName(), tokenValue, antiCsrfToken.getFormIndex()));
        }
    }

    @Override
    public void run() {
        try {
            if (!this.isStop()) {
                this.started = new Date();
                this.scan();
            }
        }
        catch (Exception e) {
            this.getLog().error((Object)e.getMessage(), (Throwable)e);
        }
        this.notifyPluginCompleted(this.getParent());
        this.finished = new Date();
    }

    @Override
    public abstract void scan();

    protected void bingo(int risk, int confidence, String uri, String param, String attack, String otherInfo, HttpMessage msg) {
        this.bingo(risk, confidence, this.getName(), this.getDescription(), uri, param, attack, otherInfo, this.getSolution(), msg);
    }

    protected void bingo(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, HttpMessage msg) {
        this.log.debug((Object)("New alert pluginid=" + this.getId() + " " + name + " uri=" + uri));
        Alert alert = new Alert(this.getId(), risk, confidence, name);
        if (uri == null || uri.equals("")) {
            uri = msg.getRequestHeader().getURI().toString();
        }
        if (param == null) {
            param = "";
        }
        alert.setDetail(description, uri, param, attack, otherInfo, solution, this.getReference(), "", this.getCweId(), this.getWascId(), msg);
        this.parent.alertFound(alert);
    }

    protected void bingo(int risk, int confidence, String uri, String param, String attack, String otherInfo, String evidence, HttpMessage msg) {
        this.bingo(risk, confidence, this.getName(), this.getDescription(), uri, param, attack, otherInfo, this.getSolution(), evidence, msg);
    }

    protected void bingo(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, HttpMessage msg) {
        this.log.debug((Object)("New alert pluginid=" + this.getId() + " " + name + " uri=" + uri));
        Alert alert = new Alert(this.getId(), risk, confidence, name);
        if (uri == null || uri.equals("")) {
            uri = msg.getRequestHeader().getURI().toString();
        }
        if (param == null) {
            param = "";
        }
        alert.setDetail(description, uri, param, attack, otherInfo, solution, this.getReference(), evidence, this.getCweId(), this.getWascId(), msg);
        this.parent.alertFound(alert);
    }

    protected void bingo(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, int cweId, int wascId, HttpMessage msg) {
        this.log.debug((Object)("New alert pluginid=" + this.getId() + " " + name + " uri=" + uri));
        Alert alert = new Alert(this.getId(), risk, confidence, name);
        if (uri == null || uri.equals("")) {
            uri = msg.getRequestHeader().getURI().toString();
        }
        if (param == null) {
            param = "";
        }
        alert.setDetail(description, uri, param, attack, otherInfo, solution, this.getReference(), evidence, cweId, wascId, msg);
        this.parent.alertFound(alert);
    }

    protected boolean isFileExist(HttpMessage msg) {
        return this.parent.getAnalyser().isFileExist(msg);
    }

    protected boolean isStop() {
        return this.parent.isStop() || this.parent.isSkipped(this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.setProperty("enabled", Boolean.toString(enabled));
            if (enabled && this.getAlertThreshold() == Plugin.AlertThreshold.OFF) {
                this.setAlertThreshold(Plugin.AlertThreshold.DEFAULT);
            }
        }
    }

    @Override
    public Plugin.AlertThreshold getAlertThreshold() {
        return this.getAlertThreshold(false);
    }

    @Override
    public Plugin.AlertThreshold getAlertThreshold(boolean incDefault) {
        Plugin.AlertThreshold level = null;
        try {
            level = Plugin.AlertThreshold.valueOf(this.getProperty("level"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (level == null) {
            level = this.isEnabled() ? (incDefault ? Plugin.AlertThreshold.DEFAULT : this.defaultAttackThreshold) : Plugin.AlertThreshold.OFF;
        } else if (level.equals((Object)Plugin.AlertThreshold.DEFAULT)) {
            level = incDefault ? Plugin.AlertThreshold.DEFAULT : this.defaultAttackThreshold;
        }
        return level;
    }

    @Override
    public void setAlertThreshold(Plugin.AlertThreshold level) {
        this.setProperty("level", level.name());
        this.setEnabled(level != Plugin.AlertThreshold.OFF);
    }

    @Override
    public void setDefaultAlertThreshold(Plugin.AlertThreshold level) {
        this.defaultAttackThreshold = level;
    }

    @Override
    public Plugin.AlertThreshold[] getAlertThresholdsSupported() {
        return alertThresholdsSupported;
    }

    @Override
    public Plugin.AttackStrength getAttackStrength(boolean incDefault) {
        Plugin.AttackStrength level = null;
        try {
            level = Plugin.AttackStrength.valueOf(this.getProperty("strength"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (level == null) {
            level = incDefault ? Plugin.AttackStrength.DEFAULT : this.defaultAttackStrength;
        } else if (level.equals((Object)Plugin.AttackStrength.DEFAULT)) {
            level = incDefault ? Plugin.AttackStrength.DEFAULT : this.defaultAttackStrength;
        }
        return level;
    }

    @Override
    public Plugin.AttackStrength getAttackStrength() {
        return this.getAttackStrength(false);
    }

    @Override
    public void setAttackStrength(Plugin.AttackStrength level) {
        this.setProperty("strength", level.name());
    }

    @Override
    public void setDefaultAttackStrength(Plugin.AttackStrength strength) {
        this.defaultAttackStrength = strength;
    }

    @Override
    public Plugin.AttackStrength[] getAttackStrengthsSupported() {
        return attackStrengthsSupported;
    }

    @Override
    public int compareTo(Object obj) {
        int result = -1;
        if (obj instanceof AbstractPlugin) {
            AbstractPlugin test = (AbstractPlugin)obj;
            result = this.getId() < test.getId() ? -1 : (this.getId() > test.getId() ? 1 : 0);
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    protected boolean matchHeaderPattern(HttpMessage msg, String header, Pattern pattern) {
        if (msg.getResponseHeader().isEmpty()) {
            return false;
        }
        String val = msg.getResponseHeader().getHeader(header);
        if (val == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(val);
        return matcher.find();
    }

    protected boolean matchBodyPattern(HttpMessage msg, Pattern pattern, StringBuilder sb) {
        Matcher matcher = pattern.matcher(msg.getResponseBody().toString());
        boolean result = matcher.find();
        if (result && sb != null) {
            sb.append(matcher.group());
        }
        return result;
    }

    protected void writeProgress(String msg) {
    }

    public HostProcess getParent() {
        return this.parent;
    }

    @Override
    public abstract void notifyPluginCompleted(HostProcess var1);

    protected String stripOff(String body, String pattern) {
        String urlEncodePattern = AbstractPlugin.getURLEncode(pattern);
        String urlDecodePattern = AbstractPlugin.getURLDecode(pattern);
        String htmlEncodePattern1 = AbstractPlugin.getHTMLEncode(pattern);
        String htmlEncodePattern2 = AbstractPlugin.getHTMLEncode(urlEncodePattern);
        String htmlEncodePattern3 = AbstractPlugin.getHTMLEncode(urlDecodePattern);
        String result = body.replaceAll("\\Q" + pattern + "\\E", "").replaceAll("\\Q" + urlEncodePattern + "\\E", "").replaceAll("\\Q" + urlDecodePattern + "\\E", "");
        result = result.replaceAll("\\Q" + htmlEncodePattern1 + "\\E", "").replaceAll("\\Q" + htmlEncodePattern2 + "\\E", "").replaceAll("\\Q" + htmlEncodePattern3 + "\\E", "");
        return result;
    }

    public static String getURLEncode(String msg) {
        String result = "";
        try {
            result = URLEncoder.encode(msg, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String getURLDecode(String msg) {
        String result = "";
        try {
            result = URLDecoder.decode(msg, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static String getHTMLEncode(String msg) {
        String result = msg.replaceAll("<", "&#60;");
        result = result.replaceAll(">", "&#62;");
        return result;
    }

    protected Kb getKb() {
        return this.getParent().getKb();
    }

    protected Logger getLog() {
        return this.log;
    }

    public String getProperty(String key) {
        return this.getProperty(this.config, key);
    }

    private String getProperty(Configuration conf, String key) {
        return conf.getString("plugins.p" + this.getId() + "." + key);
    }

    public void setProperty(String key, String value) {
        this.setProperty(this.config, key, value);
    }

    private void setProperty(Configuration conf, String key, String value) {
        conf.setProperty("plugins.p" + this.getId() + "." + key, (Object)value);
    }

    @Override
    public void setConfig(Configuration config) {
        this.config = config;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public void saveTo(Configuration conf) {
        this.setProperty(conf, "enabled", Boolean.toString(this.enabled));
        this.setProperty(conf, "level", this.getProperty("level"));
        this.setProperty(conf, "strength", this.getProperty("strength"));
    }

    @Override
    public void loadFrom(Configuration conf) {
        this.setProperty("level", this.getProperty(conf, "level"));
        this.setProperty("strength", this.getProperty(conf, "strength"));
        String enabledProperty = this.getProperty(conf, "enabled");
        if (enabledProperty != null) {
            this.enabled = Boolean.parseBoolean(enabledProperty);
        } else {
            this.enabled = this.getAlertThreshold() != Plugin.AlertThreshold.OFF;
            enabledProperty = Boolean.toString(this.enabled);
        }
        this.setProperty("enabled", enabledProperty);
    }

    @Override
    public void cloneInto(Plugin plugin) {
        if (!(plugin instanceof AbstractPlugin)) {
            throw new InvalidParameterException("Not an AbstractPlugin");
        }
        AbstractPlugin ap = (AbstractPlugin)plugin;
        ap.setAlertThreshold(this.getAlertThreshold(true));
        ap.setEnabled(this.isEnabled());
        ap.setAttackStrength(this.getAttackStrength(true));
        ap.setDefaultAlertThreshold(this.defaultAttackThreshold);
        ap.setDefaultAttackStrength(this.defaultAttackStrength);
        ap.setTechSet(this.getTechSet());
        ap.setStatus(this.getStatus());
        ap.saveTo(plugin.getConfig());
    }

    @Override
    public void createParamIfNotExist() {
        if (this.getProperty("enabled") == null) {
            this.setEnabled(this.getAlertThreshold() != Plugin.AlertThreshold.OFF);
        }
    }

    @Override
    public boolean isDepreciated() {
        return false;
    }

    @Override
    public int getRisk() {
        return 2;
    }

    @Override
    public int getDelayInMs() {
        return this.delayInMs;
    }

    @Override
    public void setDelayInMs(int delayInMs) {
        this.delayInMs = delayInMs;
    }

    @Override
    public boolean inScope(Tech tech) {
        return this.techSet == null || this.techSet.includes(tech);
    }

    @Override
    public void setTechSet(TechSet ts) {
        this.techSet = ts;
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    @Override
    public boolean targets(TechSet technologies) {
        return true;
    }

    @Override
    public Date getTimeStarted() {
        return this.started;
    }

    @Override
    public Date getTimeFinished() {
        return this.finished;
    }

    @Override
    public void setTimeStarted() {
        this.started = new Date();
        this.finished = null;
    }

    @Override
    public void setTimeFinished() {
        this.finished = new Date();
    }

    @Override
    public int getCweId() {
        return 0;
    }

    @Override
    public int getWascId() {
        return 0;
    }

    @Override
    public AddOn.Status getStatus() {
        return this.status;
    }

    public void setStatus(AddOn.Status status) {
        this.status = status;
    }
}

