/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.ZAP;

public class CommandLine {
    private static final Logger logger = Logger.getLogger(CommandLine.class);
    public static final String SESSION = "-session";
    public static final String NEW_SESSION = "-newsession";
    public static final String DAEMON = "-daemon";
    public static final String HELP = "-help";
    public static final String HELP2 = "-h";
    public static final String DIR = "-dir";
    public static final String VERSION = "-version";
    public static final String PORT = "-port";
    public static final String HOST = "-host";
    public static final String CMD = "-cmd";
    public static final String INSTALL_DIR = "-installdir";
    public static final String CONFIG = "-config";
    public static final String LOWMEM = "-lowmem";
    public static final String EXPERIMENTALDB = "-experimentaldb";
    static final String NO_USER_AGENT = "-nouseragent";
    static final String SP = "-sp";
    private boolean GUI = true;
    private boolean daemon = false;
    private boolean reportVersion = false;
    private boolean lowMem = false;
    private boolean experimentalDb = false;
    private int port = -1;
    private String host = null;
    private String[] args = null;
    private final Hashtable<String, String> configs = new Hashtable();
    private final Hashtable<String, String> keywords = new Hashtable();
    private List<CommandLineArgument[]> commandList = null;

    public CommandLine(String[] args) throws Exception {
        this.args = args;
        this.parseFirst(this.args);
    }

    private boolean checkPair(String[] args, String paramName, int i) throws Exception {
        String key = args[i];
        String value = null;
        if (key == null) {
            return false;
        }
        if (key.equalsIgnoreCase(paramName)) {
            value = args[i + 1];
            if (value == null) {
                throw new Exception();
            }
            this.keywords.put(paramName, value);
            args[i] = null;
            args[i + 1] = null;
            return true;
        }
        return false;
    }

    private boolean checkSwitch(String[] args, String paramName, int i) throws Exception {
        String key = args[i];
        if (key == null) {
            return false;
        }
        if (key.equalsIgnoreCase(paramName)) {
            this.keywords.put(paramName, "");
            args[i] = null;
            return true;
        }
        return false;
    }

    private void parseFirst(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (!this.parseSwitchs(args, i) && !this.parseKeywords(args, i)) continue;
        }
    }

    public void parse(List<CommandLineArgument[]> commandList, Map<String, CommandLineListener> extMap) throws Exception {
        int i;
        this.commandList = commandList;
        CommandLineArgument lastArg = null;
        boolean found = false;
        int remainingValueCount = 0;
        for (i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            found = false;
            for (int j = 0; j < commandList.size() && !found; ++j) {
                CommandLineArgument[] extArg = commandList.get(j);
                for (int k = 0; k < extArg.length && !found; ++k) {
                    if (this.args[i].compareToIgnoreCase(extArg[k].getName()) != 0) continue;
                    if (remainingValueCount > 0) {
                        throw new Exception("Missing parameters for keyword '" + lastArg.getName() + "'.");
                    }
                    lastArg = extArg[k];
                    lastArg.setEnabled(true);
                    found = true;
                    this.args[i] = null;
                    remainingValueCount = lastArg.getNumOfArguments();
                }
            }
            if (this.args[i] != null && this.args[i].startsWith("-") || lastArg != null && remainingValueCount == 0 || found || lastArg == null) continue;
            if (lastArg.getPattern() == null || lastArg.getPattern().matcher(this.args[i]).find()) {
                lastArg.getArguments().add(this.args[i]);
                if (remainingValueCount > 0) {
                    --remainingValueCount;
                }
                this.args[i] = null;
                continue;
            }
            throw new Exception(lastArg.getErrorMessage());
        }
        if (lastArg != null && remainingValueCount > 0) {
            throw new Exception("Missing parameters for keyword '" + lastArg.getName() + "'.");
        }
        for (i = 0; i < this.args.length; ++i) {
            String ext;
            CommandLineListener cll;
            File file;
            int dotIndex;
            if (this.args[i] == null || (dotIndex = this.args[i].lastIndexOf(".")) < 0 || !(file = new File(this.args[i])).exists() || !file.canRead() || (cll = extMap.get(ext = this.args[i].substring(dotIndex + 1))) == null || !cll.handleFile(file)) continue;
            found = true;
            this.args[i] = null;
        }
        for (String arg : this.args) {
            if (arg == null) continue;
            if (arg.startsWith("-")) {
                throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.badparam"), arg));
            }
            File f = new File(arg);
            if (!f.exists()) {
                throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.nofile"), arg));
            }
            if (!f.canRead()) {
                throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.noread"), arg));
            }
            throw new Exception(MessageFormat.format(Constant.messages.getString("start.cmdline.badfile"), arg));
        }
    }

    private boolean parseSwitchs(String[] args, int i) throws Exception {
        boolean result = false;
        if (this.checkSwitch(args, NO_USER_AGENT, i)) {
            HttpSender.setUserAgent("");
            Constant.setEyeCatcher("");
            result = true;
        } else if (this.checkSwitch(args, SP, i)) {
            Constant.setSP(true);
            result = true;
        } else if (this.checkSwitch(args, CMD, i)) {
            this.setDaemon(false);
            this.setGUI(false);
        } else if (this.checkSwitch(args, DAEMON, i)) {
            this.setDaemon(true);
            this.setGUI(false);
        } else if (this.checkSwitch(args, LOWMEM, i)) {
            this.setLowMem(true);
        } else if (this.checkSwitch(args, EXPERIMENTALDB, i)) {
            this.setExperimentalDb(true);
        } else if (this.checkSwitch(args, HELP, i)) {
            result = true;
            this.setGUI(false);
        } else if (this.checkSwitch(args, HELP2, i)) {
            result = true;
            this.setGUI(false);
        } else if (this.checkSwitch(args, VERSION, i)) {
            this.reportVersion = true;
            this.setDaemon(false);
            this.setGUI(false);
        }
        return result;
    }

    private boolean parseKeywords(String[] args, int i) throws Exception {
        String pair;
        boolean result = false;
        if (this.checkPair(args, NEW_SESSION, i)) {
            result = true;
        } else if (this.checkPair(args, SESSION, i)) {
            result = true;
        } else if (this.checkPair(args, DIR, i)) {
            Constant.setZapHome(this.keywords.get(DIR));
            result = true;
        } else if (this.checkPair(args, INSTALL_DIR, i)) {
            Constant.setZapInstall(this.keywords.get(INSTALL_DIR));
            result = true;
        } else if (this.checkPair(args, HOST, i)) {
            this.host = this.keywords.get(HOST);
            result = true;
        } else if (this.checkPair(args, PORT, i)) {
            this.port = Integer.parseInt(this.keywords.get(PORT));
            result = true;
        } else if (this.checkPair(args, CONFIG, i) && (pair = this.keywords.get(CONFIG)) != null && pair.indexOf("=") > 0) {
            int eqIndex = pair.indexOf("=");
            this.configs.put(pair.substring(0, eqIndex), pair.substring(eqIndex + 1));
            result = true;
        }
        return result;
    }

    public boolean isGUI() {
        return this.GUI;
    }

    public void setGUI(boolean GUI) {
        this.GUI = GUI;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isLowMem() {
        return this.lowMem;
    }

    public void setLowMem(boolean lowMem) {
        this.lowMem = lowMem;
    }

    public boolean isExperimentalDb() {
        return this.experimentalDb;
    }

    public void setExperimentalDb(boolean experimentalDb) {
        this.experimentalDb = experimentalDb;
    }

    public boolean isReportVersion() {
        return this.reportVersion;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public Hashtable<String, String> getConfigs() {
        return this.configs;
    }

    public String getArgument(String keyword) {
        return this.keywords.get(keyword);
    }

    public String getHelp() {
        return CommandLine.getHelp(this.commandList);
    }

    public static String getHelp(List<CommandLineArgument[]> cmdList) {
        String zap = Constant.isWindows() ? "zap.bat" : "zap.sh";
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format(Constant.messages.getString("cmdline.help"), zap));
        if (cmdList != null) {
            for (CommandLineArgument[] extArgs : cmdList) {
                for (CommandLineArgument extArg : extArgs) {
                    sb.append("\t");
                    sb.append(extArg.getHelpMessage()).append("\n");
                }
            }
        }
        return sb.toString();
    }

    public boolean isEnabled(String keyword) {
        String obj = this.keywords.get(keyword);
        return obj != null && obj instanceof String;
    }

    public static void info(String str) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.out.println(str);
                break;
            }
        }
        logger.info((Object)str);
    }

    public static void error(String str) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.err.println(str);
                break;
            }
        }
        logger.error((Object)str);
    }

    public static void error(String str, Throwable e) {
        switch (ZAP.getProcessType()) {
            case cmdline: {
                System.err.println(str);
                break;
            }
        }
        logger.error((Object)str, e);
    }
}

