/*
 * Decompiled with CFR 0.152.
 */
package ch.csnc.extension.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class DriverConfiguration
extends Observable {
    private File file = null;
    private Vector<String> names;
    private Vector<String> paths;
    private Vector<Integer> slots;
    private Vector<Integer> slotListIndexes;
    private final Logger logger = Logger.getLogger(this.getClass());

    public DriverConfiguration(File file) {
        this.file = file;
        this.names = new Vector();
        this.paths = new Vector();
        this.slots = new Vector();
        this.slotListIndexes = new Vector();
        try {
            Document doc = new SAXBuilder().build(file);
            Element root = doc.getRootElement();
            for (Object o : root.getChildren("driver")) {
                Element nameElement = ((Element)o).getChild("name");
                this.names.add(nameElement.getValue());
                Element pathElement = ((Element)o).getChild("path");
                this.paths.add(pathElement.getValue());
                Element slotElement = ((Element)o).getChild("slot");
                try {
                    this.slots.add(Integer.parseInt(slotElement.getValue()));
                }
                catch (Exception e) {
                    this.slots.add(0);
                }
                Element slotListIndex = ((Element)o).getChild("slotListIndex");
                try {
                    this.slotListIndexes.add(Integer.parseInt(slotListIndex.getValue()));
                }
                catch (Exception e) {
                    this.slotListIndexes.add(0);
                }
            }
        }
        catch (JDOMException e) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", e.toString()}, "Error", 0);
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", e.toString()}, "Error", 0);
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, new String[]{"Error slot or slot list index is not a number: ", e.toString()}, "Error", 0);
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void write() {
        Document doc = new Document();
        Element root = new Element("driverConfiguration");
        doc.addContent((Content)root);
        for (int i = 0; i < this.names.size(); ++i) {
            Element driver = new Element("driver");
            root.addContent((Content)driver);
            Element name = new Element("name");
            driver.addContent((Content)name);
            name.addContent(this.names.get(i));
            Element path = new Element("path");
            driver.addContent((Content)path);
            path.addContent(this.paths.get(i));
            Element slot = new Element("slot");
            driver.addContent((Content)slot);
            slot.addContent(this.slots.get(i).toString());
            Element slotListIndex = new Element("slotListIndex");
            driver.addContent((Content)slotListIndex);
            slotListIndex.addContent(this.slotListIndexes.get(i).toString());
        }
        try {
            BufferedOutputStream fileOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
            XMLOutputter out = new XMLOutputter();
            out.output(doc, (OutputStream)fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", e.toString()}, "Error", 0);
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, new String[]{"Error accessing key store: ", e.toString()}, "Error", 0);
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Vector<String> getNames() {
        return this.names;
    }

    public void setNames(Vector<String> names) {
        this.names = names;
    }

    public Vector<String> getPaths() {
        return this.paths;
    }

    public void setPaths(Vector<String> paths) {
        this.paths = paths;
    }

    public Vector<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(Vector<Integer> slots) {
        this.slots = slots;
    }

    public Vector<Integer> getSlotIndexes() {
        return this.slotListIndexes;
    }

    public void setSlotListIndexes(Vector<Integer> slotListIndexes) {
        this.slotListIndexes = slotListIndexes;
    }
}

