/*
 * Zed Attack Proxy (ZAP) and its related class files.
 * 
 * ZAP is an HTTP/HTTPS proxy for assessing web application security.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 *   
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 */
package org.zaproxy.zap.extension.siterefresh;

import java.awt.Component;

import javax.swing.JTree;

import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;

public class PopupMenuSitesRefresh extends ExtensionPopupMenuItem {

	private static final long serialVersionUID = 1L;
    
    /**
     * 
     */
    public PopupMenuSitesRefresh() {
        super();
 		initialize();
    }

    /**
     * @param label
     */
    public PopupMenuSitesRefresh(String label) {
        super(label);
    }

    /**
	 * This method initializes this
	 */
	private void initialize() {
        this.setText(Constant.messages.getString("siterefresh.popop"));
        
        this.addActionListener(new java.awt.event.ActionListener() { 

        	@Override
        	public void actionPerformed(java.awt.event.ActionEvent e) {
        		Session session = Model.getSingleton().getSession();
        		SiteMap map = session.getSiteTree();
        		map.reload();
        	}
        });
			
	}
	
    @Override
    public boolean isEnableForComponent(Component invoker) {
        if (invoker instanceof JTree) {
            JTree tree = (JTree) invoker;
            if (tree.getName().equals("treeSite")) {
				this.setEnabled(true);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean precedeWithSeparator() {
    	return true;
    }

}
