/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.addon.network.internal.handlers.LegacySocketAdapter;
import org.zaproxy.addon.network.internal.server.http.MainServerHandler;
import org.zaproxy.addon.network.internal.server.http.handlers.LegacyProxyListenerHandler;
import org.zaproxy.addon.network.server.HttpMessageHandler;
import org.zaproxy.zap.ZapGetMethod;

public class MainProxyHandler
extends MainServerHandler {
    private final LegacyProxyListenerHandler legacyHandler;

    public MainProxyHandler(LegacyProxyListenerHandler legacyHandler, List<HttpMessageHandler> handlers) {
        super(handlers);
        this.legacyHandler = Objects.requireNonNull(legacyHandler);
    }

    @Override
    protected boolean postWriteResponse(ChannelHandlerContext ctx, HttpMessage msg) {
        boolean keepConnectionOpen;
        if (msg.getResponseHeader().getStatusCode() != 101 && !msg.isEventStream()) {
            return false;
        }
        LegacySocketAdapter passthroughAdapter = new LegacySocketAdapter(ctx.channel());
        ZapGetMethod method = (ZapGetMethod)msg.getUserObject();
        if (method == null) {
            method = new ZapGetMethod();
            method.setUpgradedSocket(passthroughAdapter.getSocket());
            try {
                method.setUpgradedInputStream(passthroughAdapter.getSocket().getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (keepConnectionOpen = this.legacyHandler.notifyPersistentConnectionListener(msg, passthroughAdapter.getSocket(), method)) {
            return true;
        }
        MainProxyHandler.close(ctx);
        return true;
    }
}

