/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.parosproxy.paros.security.SslCertificateService;
import org.zaproxy.addon.network.internal.ChannelAttributes;
import org.zaproxy.addon.network.internal.codec.HttpRequestDecoder;
import org.zaproxy.addon.network.internal.codec.HttpResponseEncoder;
import org.zaproxy.addon.network.internal.handlers.ConnectRequestHandler;
import org.zaproxy.addon.network.internal.handlers.ReadTimeoutHandler;
import org.zaproxy.addon.network.internal.handlers.RecursiveRequestHandler;
import org.zaproxy.addon.network.internal.handlers.ServerExceptionHandler;
import org.zaproxy.addon.network.internal.handlers.TlsConfig;
import org.zaproxy.addon.network.internal.handlers.TlsProtocolHandler;
import org.zaproxy.addon.network.internal.server.BaseServer;
import org.zaproxy.addon.network.internal.server.http.DefaultServerConfig;
import org.zaproxy.addon.network.internal.server.http.MainServerHandler;

public class HttpServer
extends BaseServer {
    private final EventExecutorGroup mainHandlerExecutor;
    private final SslCertificateService sslCertificateService;
    private final Supplier<MainServerHandler> handler;
    private DefaultServerConfig serverConfig;
    private TlsConfig tlsConfig;

    public HttpServer(NioEventLoopGroup group, EventExecutorGroup mainHandlerExecutor, SslCertificateService sslCertificateService, Supplier<MainServerHandler> handler) {
        super(group);
        this.mainHandlerExecutor = Objects.requireNonNull(mainHandlerExecutor);
        this.sslCertificateService = Objects.requireNonNull(sslCertificateService);
        this.handler = Objects.requireNonNull(handler);
        this.tlsConfig = new TlsConfig();
        this.serverConfig = new DefaultServerConfig();
        this.setChannelInitialiser(this::initChannel);
    }

    private void initChannel(SocketChannel ch) {
        ch.attr(ChannelAttributes.CERTIFICATE_SERVICE).set((Object)this.sslCertificateService);
        ch.attr(ChannelAttributes.SERVER_CONFIG).set((Object)this.serverConfig);
        ch.attr(ChannelAttributes.TLS_CONFIG).set((Object)this.tlsConfig);
        ch.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(20, TimeUnit.SECONDS)).addLast("tls.upgrade", (ChannelHandler)new TlsProtocolHandler()).addLast("http.decoder", (ChannelHandler)new HttpRequestDecoder()).addLast("http.encoder", (ChannelHandler)HttpResponseEncoder.getInstance()).addLast("http.connect", (ChannelHandler)ConnectRequestHandler.getInstance()).addLast("http.recursive", (ChannelHandler)RecursiveRequestHandler.getInstance()).addLast(this.mainHandlerExecutor, "http.main-handler", (ChannelHandler)this.handler.get()).addLast("exception", (ChannelHandler)new ServerExceptionHandler());
    }

    @Override
    public int start(String address, int port) throws IOException {
        int boundPort = super.start(address, port);
        this.serverConfig.setAddress(address);
        return boundPort;
    }
}

