/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.server.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Set;
import org.zaproxy.addon.network.internal.server.ServerConfig;

public class DefaultServerConfig
implements ServerConfig {
    private boolean anyLocalAddress;

    public DefaultServerConfig() {
        this.setAddress("127.0.0.1");
    }

    public void setAddress(String address) {
        this.anyLocalAddress = DefaultServerConfig.isAnyLocalAddress(address);
    }

    @Override
    public boolean isAnyLocalAddress() {
        return this.anyLocalAddress;
    }

    @Override
    public Set<String> getAliases() {
        return Collections.emptySet();
    }

    @Override
    public boolean isBehindNat() {
        return false;
    }

    private static boolean isAnyLocalAddress(String address) {
        try {
            return address.isEmpty() || InetAddress.getByName(address).isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

