/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.zaproxy.addon.network.internal.handlers.TlsProtocolHandler;

@ChannelHandler.Sharable
public class ConnectRequestHandler
extends SimpleChannelInboundHandler<HttpMessage> {
    private static final ConnectRequestHandler INSTANCE = new ConnectRequestHandler();

    public static ConnectRequestHandler getInstance() {
        return INSTANCE;
    }

    public boolean isSharable() {
        return true;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
        if (msg.getUserObject() instanceof Exception) {
            throw (Exception)msg.getUserObject();
        }
        HttpRequestHeader request = msg.getRequestHeader();
        boolean connect = "CONNECT".equals(request.getMethod());
        ctx.fireChannelRead((Object)msg);
        ctx.pipeline().remove((ChannelHandler)this);
        if (!connect) {
            return;
        }
        ctx.pipeline().addFirst("tls.upgrade", (ChannelHandler)new TlsProtocolHandler(request.getHostName()));
        ctx.fireChannelReadComplete();
    }
}

