/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.network.internal.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.addon.network.internal.codec.HttpRequestEncoder;
import org.zaproxy.addon.network.internal.codec.HttpResponseDecoder;

public class HttpClientCodec
extends CombinedChannelDuplexHandler<HttpResponseDecoder, HttpRequestEncoder> {
    private final Queue<String> queue = new ArrayDeque<String>();

    public HttpClientCodec() {
        this.init((ChannelInboundHandler)new Decoder(), (ChannelOutboundHandler)new Encoder());
    }

    private class Decoder
    extends HttpResponseDecoder {
        private Decoder() {
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
            super.decode(ctx, buffer, out);
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpMessage msg) {
            String method = (String)HttpClientCodec.this.queue.poll();
            int statusCode = msg.getResponseHeader().getStatusCode();
            if (statusCode >= 100 && statusCode < 200) {
                return super.isContentAlwaysEmpty(msg);
            }
            if (method != null) {
                char firstChar = method.charAt(0);
                switch (firstChar) {
                    case 'H': {
                        if (!"HEAD".equals(method)) break;
                        return true;
                    }
                    case 'C': {
                        if (statusCode != 200 || !"CONNECT".equals(method)) break;
                        return true;
                    }
                }
            }
            return super.isContentAlwaysEmpty(msg);
        }
    }

    private class Encoder
    extends HttpRequestEncoder {
        private Encoder() {
        }

        @Override
        protected void encode(ChannelHandlerContext ctx, HttpMessage msg, ByteBuf out) {
            HttpClientCodec.this.queue.offer(msg.getRequestHeader().getMethod());
            super.encode(ctx, msg, out);
        }
    }
}

