/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.addon.commonlib.binlist;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.collections4.Trie;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.log4j.Logger;
import org.zaproxy.addon.commonlib.binlist.BinRecord;

public final class BinList {
    private static final Logger LOGGER = Logger.getLogger(BinList.class);
    private static final String BINLIST = "binlist-data.csv";
    private static BinList singleton;
    private Trie<String, BinRecord> trie = BinList.createTrie();

    private BinList() {
    }

    public static BinList getSingleton() {
        if (singleton == null) {
            BinList.createSingleton();
        }
        return singleton;
    }

    private static synchronized void createSingleton() {
        if (singleton == null) {
            singleton = new BinList();
        }
    }

    private static Trie<String, BinRecord> createTrie() {
        List records;
        PatriciaTrie trie = new PatriciaTrie();
        try (InputStream in = BinList.class.getResourceAsStream(BINLIST);
             BOMInputStream bomStream = new BOMInputStream(in);
             InputStreamReader inStream = new InputStreamReader((InputStream)bomStream, StandardCharsets.UTF_8);){
            records = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse((Reader)inStream).getRecords();
        }
        catch (IOException | NullPointerException e) {
            LOGGER.warn((Object)"Exception while loading: binlist-data.csv", (Throwable)e);
            return trie;
        }
        for (CSVRecord record : records) {
            trie.put((Object)record.get("bin"), (Object)new BinRecord(record.get("bin"), record.get("brand"), record.get("category"), record.get("issuer")));
        }
        return trie;
    }

    public BinRecord get(String candidate) {
        BinRecord binRec = (BinRecord)this.trie.get((Object)candidate);
        if (binRec == null) {
            binRec = (BinRecord)this.trie.get((Object)candidate.substring(0, 6));
        }
        if (binRec == null) {
            binRec = (BinRecord)this.trie.get((Object)candidate.substring(0, 8));
        }
        if (binRec == null) {
            binRec = (BinRecord)this.trie.get((Object)candidate.substring(0, 5));
        }
        if (binRec == null) {
            binRec = (BinRecord)this.trie.get((Object)candidate.substring(0, 7));
        }
        return binRec;
    }
}

