/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.stups.swagger.codegen;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.zalando.stups.swagger.codegen.CodegenerationException;
import org.zalando.stups.swagger.codegen.CodegeneratorLogger;
import org.zalando.stups.swagger.codegen.ConfigurableCodegenConfig;
import org.zalando.stups.swagger.codegen.SystemOutCodegeneratorLogger;

public class StandaloneCodegenerator {
    private Map<String, CodegenConfig> configs = new HashMap<String, CodegenConfig>();
    private CodegeneratorLogger codeGeneratorLogger = new SystemOutCodegeneratorLogger();
    private String apiFile;
    private String language;
    private File outputDirectory;
    private String apiPackage;
    private String modelPackage;
    private boolean skipApigeneration;
    private boolean skipModelgeneration;
    private boolean enable303;
    private boolean enableBuilderSupport;
    private Map<String, Object> additionalProperties;
    private List<String> excludedModels;
    private boolean skipModelTests = true;
    private boolean skipModelDocs = true;
    private boolean skipApiTests = true;
    private boolean skipApiDocs = true;

    public static CodegeneratorBuilder builder() {
        return new CodegeneratorBuilder();
    }

    public void generate() throws CodegenerationException {
        if (!this.getOutputDirectory().exists()) {
            this.getOutputDirectory().mkdirs();
        }
        this.checkModelPackage();
        this.checkApiFileExist();
        this.prepare();
        ClientOptInput clientOptInput = new ClientOptInput();
        ClientOpts clientOpts = new ClientOpts();
        Swagger swagger = null;
        this.getLog().info("Generate for language : " + this.language);
        CodegenConfig codegenConfig = this.getConfig(this.language);
        if (codegenConfig == null) {
            throw new CodegenerationException("No CodegenConfig-Implementation found for " + this.language);
        }
        codegenConfig.additionalProperties().putAll(this.additionalProperties);
        if (codegenConfig instanceof ConfigurableCodegenConfig) {
            if (this.skipApigeneration) {
                ((ConfigurableCodegenConfig)codegenConfig).skipApiGeneration();
            }
            if (this.skipModelgeneration) {
                ((ConfigurableCodegenConfig)codegenConfig).skipModelGeneration();
            }
            if (this.skipApigeneration && this.apiPackage == null) {
                ((ConfigurableCodegenConfig)codegenConfig).setApiPackage("");
            } else {
                ((ConfigurableCodegenConfig)codegenConfig).setApiPackage(this.apiPackage);
            }
            if (this.skipModelgeneration && this.modelPackage == null) {
                ((ConfigurableCodegenConfig)codegenConfig).setModelPackage("");
            } else {
                ((ConfigurableCodegenConfig)codegenConfig).setModelPackage(this.modelPackage);
            }
            if (this.enable303) {
                this.getLog().info("JSR 303 enabled ...");
                if (((ConfigurableCodegenConfig)codegenConfig).is303Supported()) {
                    this.getLog().info("and supported by " + this.language);
                    ((ConfigurableCodegenConfig)codegenConfig).enable303();
                } else {
                    this.getLog().info("but not supported by " + this.language);
                }
            }
            if (this.enableBuilderSupport) {
                this.getLog().info("BuilderSupport enabled ...");
                if (((ConfigurableCodegenConfig)codegenConfig).isBuilderSupported()) {
                    this.getLog().info("and supported by : " + this.language);
                    ((ConfigurableCodegenConfig)codegenConfig).enableBuilderSupport();
                } else {
                    this.getLog().info("but not supported by : " + this.language);
                }
            }
        }
        clientOptInput.setConfig(codegenConfig);
        clientOptInput.getConfig().setOutputDir(this.outputDirectory.getAbsolutePath());
        swagger = new SwaggerParser().read(this.apiFile, clientOptInput.getAuthorizationValues(), true);
        if (this.skipApigeneration) {
            this.getLog().info("API-GENERATION DISABLED ...");
            System.setProperty("models", "");
            swagger.setPaths(new HashMap(0));
        }
        if (this.skipModelgeneration) {
            this.getLog().info("MODEL-GENERATION DISABLED ...");
            System.setProperty("apis", "");
            swagger.setDefinitions(new HashMap(0));
        } else if (!this.excludedModels.isEmpty()) {
            Iterator it = swagger.getDefinitions().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!this.excludedModels.contains(entry.getKey())) continue;
                this.getLog().info("REMOVE MODEL '" + (String)entry.getKey() + "' FROM GENERATION ...");
                it.remove();
            }
        }
        if (this.skipModelTests) {
            System.setProperty("modelTests", Boolean.FALSE.toString());
        }
        if (this.skipModelDocs) {
            System.setProperty("modelDocs", Boolean.FALSE.toString());
        }
        if (this.skipApiTests) {
            System.setProperty("apiTests", Boolean.FALSE.toString());
        }
        if (this.skipApiDocs) {
            System.setProperty("apiDocs", Boolean.FALSE.toString());
        }
        try {
            clientOptInput.opts(clientOpts).swagger(swagger);
            DefaultGenerator generator = (DefaultGenerator)new DefaultGenerator().opts(clientOptInput);
            List generatedFiles = generator.generate();
            this.getLog().info(generatedFiles.size() + " generated Files");
        }
        catch (Exception e) {
            throw new CodegenerationException(e.getMessage(), e);
        }
    }

    public String getOutputDirectoryPath() {
        return this.getOutputDirectory().getAbsolutePath();
    }

    private CodegeneratorLogger getLog() {
        return this.codeGeneratorLogger;
    }

    protected void checkModelPackage() {
        if (this.modelPackage == null || this.modelPackage.trim().isEmpty()) {
            this.getLog().info("No 'modelPackage' was specified, use configured 'apiPackage' : " + this.apiPackage);
            this.modelPackage = this.apiPackage;
        }
    }

    protected void checkApiFileExist() throws CodegenerationException {
        try {
            URL url = new URL(this.apiFile);
            String prot = url.getProtocol();
            if (!"https".equals(prot) || !"http".equals(prot)) {
                this.getLog().info("'apiFile' should use 'http' or 'https'");
            }
            return;
        }
        catch (MalformedURLException e) {
            this.getLog().info("'apiFile' seems not be an valid URL, check file exist");
            File file = new File(this.apiFile);
            if (!file.exists()) {
                this.getLog().info("The 'apiFile' does not exists at : " + this.apiFile);
                throw new CodegenerationException("The 'apiFile' does not exists at : " + this.apiFile);
            }
            return;
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void prepare() {
        List<CodegenConfig> extensions = this.getExtensions();
        StringBuilder sb = new StringBuilder();
        for (CodegenConfig config : extensions) {
            if (sb.toString().length() != 0) {
                sb.append(", ");
            }
            sb.append(config.getName());
            this.getLog().info("register config : '" + config.getName() + "' with class : " + config.getClass().getName());
            this.configs.put(config.getName(), config);
        }
    }

    private CodegenConfig getConfig(String name) {
        if (this.configs.containsKey(name)) {
            return this.configs.get(name);
        }
        try {
            this.getLog().info("loading class " + name);
            Class<?> customClass = Class.forName(name);
            this.getLog().info("loaded " + name);
            return (CodegenConfig)customClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("can't load config-class for '" + name + "'", e);
        }
    }

    private List<CodegenConfig> getExtensions() {
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class);
        ArrayList<CodegenConfig> output = new ArrayList<CodegenConfig>();
        Iterator<CodegenConfig> itr = loader.iterator();
        while (itr.hasNext()) {
            output.add(itr.next());
        }
        return output;
    }

    public static class CodegeneratorBuilder {
        private CodegeneratorLogger codeGeneratorLogger;
        private String apiFile;
        private String language;
        private File outputDirectory;
        private String apiPackage;
        private String modelPackage;
        private boolean skipModelgeneration = false;
        private boolean skipApigeneration = false;
        private boolean enable303 = false;
        private boolean enableBuilderSupport = false;
        private List<String> excludedModels = new ArrayList<String>(0);
        private Map<String, Object> additionalProperties = ImmutableMap.of();

        public CodegeneratorBuilder withApiFilePath(String pathToApiFile) {
            this.apiFile = pathToApiFile;
            return this;
        }

        public CodegeneratorBuilder withApiFile(File apiFile) {
            this.apiFile = apiFile.getAbsolutePath();
            return this;
        }

        public CodegeneratorBuilder forLanguage(String languageDelimiter) {
            this.language = languageDelimiter;
            return this;
        }

        public CodegeneratorBuilder writeResultsTo(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public CodegeneratorBuilder withApiPackage(String apiPackage) {
            this.apiPackage = apiPackage;
            return this;
        }

        public CodegeneratorBuilder withModelPackage(String modelPackage) {
            this.modelPackage = modelPackage;
            return this;
        }

        public CodegeneratorBuilder withLogger(CodegeneratorLogger codegeneratorLogger) {
            this.codeGeneratorLogger = codegeneratorLogger;
            return this;
        }

        public CodegeneratorBuilder skipModelgeneration(boolean skip) {
            this.skipModelgeneration = skip;
            return this;
        }

        public CodegeneratorBuilder withModelsExcluded(List<String> excludedModels) {
            this.excludedModels = excludedModels;
            return this;
        }

        public CodegeneratorBuilder skipApigeneration(boolean skip) {
            this.skipApigeneration = skip;
            return this;
        }

        public CodegeneratorBuilder enable303(boolean enable303) {
            this.enable303 = enable303;
            return this;
        }

        public CodegeneratorBuilder enableBuilderSupport(boolean enableBuilderSupport) {
            this.enableBuilderSupport = enableBuilderSupport;
            return this;
        }

        public CodegeneratorBuilder additionalProperties(Map<String, Object> properties) {
            this.additionalProperties = properties;
            return this;
        }

        public StandaloneCodegenerator build() {
            StandaloneCodegenerator generator = new StandaloneCodegenerator();
            generator.apiFile = this.apiFile;
            generator.language = this.language;
            generator.outputDirectory = this.outputDirectory;
            generator.apiPackage = this.apiPackage;
            generator.modelPackage = this.modelPackage;
            generator.skipModelgeneration = this.skipModelgeneration;
            generator.excludedModels = this.excludedModels;
            generator.skipApigeneration = this.skipApigeneration;
            generator.enable303 = this.enable303;
            generator.enableBuilderSupport = this.enableBuilderSupport;
            generator.additionalProperties = this.additionalProperties;
            if (this.codeGeneratorLogger != null) {
                generator.codeGeneratorLogger = this.codeGeneratorLogger;
            }
            return generator;
        }
    }
}

