/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.zalando.logbook.QueryFilter;
import org.zalando.logbook.core.DefaultFilters;

@API(status=API.Status.STABLE)
public final class QueryFilters {
    private QueryFilters() {
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter defaultValue() {
        return DefaultFilters.defaultValues(QueryFilter.class).stream().reduce(QueryFilters.accessToken(), QueryFilter::merge);
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter accessToken() {
        return QueryFilters.replaceQuery("access_token", "XXX");
    }

    @API(status=API.Status.MAINTAINED)
    public static QueryFilter replaceQuery(String name, String replacement) {
        return QueryFilters.replaceQuery(name::equals, replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter replaceQuery(String name, UnaryOperator<String> replacementFunction) {
        return QueryFilters.replaceQuery(name::equals, replacementFunction);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter replaceQuery(Predicate<String> predicate, String replacement) {
        return QueryFilters.replaceQuery(predicate, s -> replacement);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter replaceQuery(Predicate<String> predicate, UnaryOperator<String> replacementFunction) {
        Pattern pattern = Pattern.compile("(?<name>[^&]*?)=(?<value>[^&]*)");
        return query -> {
            Matcher matcher = pattern.matcher(query);
            StringBuffer result = new StringBuffer(query.length());
            while (matcher.find()) {
                if (predicate.test(matcher.group("name"))) {
                    matcher.appendReplacement(result, "${name}");
                    result.append('=');
                    result.append((String)replacementFunction.apply(matcher.group("value")));
                    continue;
                }
                matcher.appendReplacement(result, "$0");
            }
            matcher.appendTail(result);
            return result.toString();
        };
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static QueryFilter removeQuery(String name) {
        Predicate<String> predicate = name::equals;
        Pattern pattern = Pattern.compile("&?(?<name>[^&]+?)=(?:[^&]*)");
        return query -> {
            Matcher matcher = pattern.matcher(query);
            StringBuffer result = new StringBuffer(query.length());
            while (matcher.find()) {
                if (predicate.test(matcher.group("name"))) {
                    matcher.appendReplacement(result, "");
                    continue;
                }
                matcher.appendReplacement(result, "$0");
            }
            matcher.appendTail(result);
            String output = result.toString();
            if (output.startsWith("&")) {
                return output.substring(1);
            }
            return output;
        };
    }
}

