/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import org.zalando.logbook.ForwardingHttpResponse;
import org.zalando.logbook.HttpHeaders;
import org.zalando.logbook.HttpResponse;
import org.zalando.logbook.attributes.HttpAttributes;
import org.zalando.logbook.core.Cache;

final class CachingHttpResponse
implements ForwardingHttpResponse {
    private final HttpResponse response;
    private final Cache<HttpHeaders> headers;
    private final HttpAttributes httpAttributes;

    CachingHttpResponse(HttpResponse response) {
        this(response, HttpAttributes.EMPTY);
    }

    CachingHttpResponse(HttpResponse response, HttpAttributes httpAttributes) {
        this.response = response;
        this.headers = new Cache<HttpHeaders>(() -> ((HttpResponse)response).getHeaders());
        this.httpAttributes = httpAttributes;
    }

    public HttpResponse delegate() {
        return this.response;
    }

    public HttpHeaders getHeaders() {
        return this.headers.get();
    }

    public HttpAttributes getAttributes() {
        return this.httpAttributes;
    }
}

