/*
 * Decompiled with CFR 0.152.
 */
package org.yatech.jedis.utils.lua;

import org.yatech.jedis.utils.lua.ast.LuaAstArg;
import org.yatech.jedis.utils.lua.ast.LuaAstAssignmentStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstDoubleValue;
import org.yatech.jedis.utils.lua.ast.LuaAstExpression;
import org.yatech.jedis.utils.lua.ast.LuaAstFunctionCallStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstIfStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstIntValue;
import org.yatech.jedis.utils.lua.ast.LuaAstLocal;
import org.yatech.jedis.utils.lua.ast.LuaAstLocalDeclaration;
import org.yatech.jedis.utils.lua.ast.LuaAstLongValue;
import org.yatech.jedis.utils.lua.ast.LuaAstNot;
import org.yatech.jedis.utils.lua.ast.LuaAstRedisCall;
import org.yatech.jedis.utils.lua.ast.LuaAstReturnStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstScript;
import org.yatech.jedis.utils.lua.ast.LuaAstStatement;
import org.yatech.jedis.utils.lua.ast.LuaAstStringValue;
import org.yatech.jedis.utils.lua.ast.LuaAstUnpack;
import org.yatech.jedis.utils.lua.ast.LuaAstVisitor;

class LuaScriptVisitor
implements LuaAstVisitor {
    private final StringBuilder sb = new StringBuilder();
    private int depth = 0;

    public String toString() {
        return this.sb.toString();
    }

    @Override
    public void visit(LuaAstScript script) {
        for (LuaAstStatement statement : script.getStatements()) {
            statement.accept(this);
        }
    }

    @Override
    public void visit(LuaAstFunctionCallStatement statement) {
        this.appendIndentation();
        statement.getFunction().accept(this);
        this.appendNewLine();
    }

    @Override
    public void visit(LuaAstAssignmentStatement statement) {
        this.appendIndentation();
        statement.getLocal().accept(this);
        this.append(" = ");
        statement.getExpression().accept(this);
        this.appendNewLine();
    }

    @Override
    public void visit(LuaAstIfStatement statement) {
        this.append("if (");
        statement.getCondition().accept(this);
        this.append(") then");
        this.appendNewLine();
        ++this.depth;
        statement.getScriptBlock().accept(this);
        --this.depth;
        this.append("end");
        this.appendNewLine();
    }

    @Override
    public void visit(LuaAstReturnStatement statement) {
        this.appendIndentation();
        this.append("return");
        if (statement.getExpression() != null) {
            this.append(" ");
            statement.getExpression().accept(this);
        }
        this.appendNewLine();
    }

    @Override
    public void visit(LuaAstRedisCall redisCall) {
        this.append("redis.call(\"");
        this.append(redisCall.getMethodName());
        this.append("\"");
        for (LuaAstExpression arg : redisCall.getArguments()) {
            this.append(",");
            arg.accept(this);
        }
        this.append(")");
    }

    @Override
    public void visit(LuaAstUnpack unpack) {
        this.append("unpack(");
        unpack.getLocal().accept(this);
        this.append(")");
    }

    @Override
    public void visit(LuaAstStringValue value) {
        this.append("\"");
        this.append((String)value.getValue());
        this.append("\"");
    }

    @Override
    public void visit(LuaAstIntValue value) {
        this.append(String.valueOf(value.getValue()));
    }

    @Override
    public void visit(LuaAstLongValue value) {
        this.append(String.valueOf(value.getValue()));
    }

    @Override
    public void visit(LuaAstDoubleValue value) {
        this.append(String.valueOf(value.getValue()));
    }

    @Override
    public void visit(LuaAstArg arg) {
        this.append(arg.getName());
    }

    @Override
    public void visit(LuaAstLocalDeclaration declaration) {
        this.append("local ");
        this.append(declaration.getName());
    }

    @Override
    public void visit(LuaAstLocal local) {
        this.append(local.getName());
    }

    @Override
    public void visit(LuaAstNot not) {
        this.append("not ");
        not.getExpression().accept(this);
    }

    private void append(String s) {
        this.sb.append(s);
    }

    private void appendIndentation() {
        for (int i = 0; i < this.depth * 2; ++i) {
            this.sb.append(" ");
        }
    }

    private void appendNewLine() {
        this.sb.append("\n");
    }
}

